package winterwell.j4square;

import org.json.JSONException;
import org.json.JSONObject;

public class A4SqObj {

	public final String id;
	public String name;

	/**
	 * id and name
	 * @param jsonObj
	 * @throws JSONException
	 */
	A4SqObj(JSONObject jsonObj) throws JSONException {
		id = jsonObj.getString("id");
		name = jsonObj.optString("name");
	}

	public A4SqObj(String id, String name) {
		this.id = id;
		this.name = name;
	}

	@Override
	public String toString() {
		return name==null? getClass().getSimpleName()+id : name;
	}

}
