package winterwell.j4square;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CheckIn {

	public final Venue venue;

	public final long id;

	public String shout;

	private String created;
	
	public String getCreated() {
		return created;
	}
	
	public String getShout() {
		return shout;
	}

	/**
	 * Can be null if this is for yourself.
	 */
	public final User4Sq user;

	private int distance;

	private String display;
	
	/**
	 * 
	 * @param obj
	 * @param user Can be null. Used only if the returned json doesn't have one
	 * @throws JSONException
	 */
	public CheckIn(JSONObject obj, User4Sq user) throws JSONException {
		id = obj.getLong("id");
		JSONObject vo = obj.optJSONObject("venue");
		venue = vo==null? null : new Venue(vo);
		shout = obj.optString("shout");		
		JSONObject uo = obj.optJSONObject("user");
		this.user = uo==null? user : new User4Sq(uo);
        distance = obj.optInt("distance");
        display = obj.optString("display");
		created = obj.getString("created");
		// TODO mayor, specials, scoring, badges		
//		mayor:{
//            type:'nochange',
//            checkins:10,
//            user:{
//                id:138,
//                firstname:'Dan',
//                lastname:'M.',
//                photo:'http://playfoursquare.s3.amazonaws.com/userpix_thumbs/138_1237786934.jpg',
//                gender:'male'
//            },
//            message:'Dan M. is The Mayor of Bowery Wine Company.'
//        },
//        badges:{
//            badge:{
//                id:123,
//                name:'Newbie',
//                icon:'http://foursquare.com/img/badge/newbie.png',
//                description:'Congrats on your first checkin!'
//            }
//        },
//        scoring:{
//            score:[
//                {
//                    points:1,
//                    icon:'http://foursquare.com/img/scoring/2.png',
//                    message:'First stop tonight'
//                },
//                {
//                    points:5,
//                    icon:'http://foursquare.com/img/scoring/1.png',
//                    message:'First time @ 4SQ HQ!'
//                }
//            ]
//        },
//        specials:{
//            special:{
//                id:2,
//                type:'mayor',
//                kind:'nearby',
//                message:'If you\'re the mayor, show the bartender and your first drink is free! (just beer and well drinks guys, let\'s be fair)',
//                venue:{
//                    id:333
//                }
//            }
//        }
	}

	@Override
	public String toString() {
		return display==null? user+" @ "+venue +" ("
				+created+")" : display;
	}
	
	static List<CheckIn> parseJsonList(String json, User4Sq user) 
	{
		try {
			JSONObject jo = new JSONObject(json);
			JSONArray cins = jo.getJSONArray("checkins");
			List<CheckIn> tweets = new ArrayList<CheckIn>();
			for (int i = 0; i < cins.length(); i++) {
				JSONObject obj = cins.getJSONObject(i);
				CheckIn tweet = new CheckIn(obj, user);
				tweets.add(tweet);
			}
			return tweets;
		} catch (JSONException e) {
			throw new FoursquareException.Parsing(json, e);
		}
	}

}
