package winterwell.j4square;

import org.json.JSONException;

public class FoursquareException extends RuntimeException {
	
	/**
	 * Problems reading the JSON returned by Twitter. 
	 * This should not normally occur!
	 * This indicates either a change in the API, or a bug in JTwitter. 
	 */
	public static class Parsing extends FoursquareException {
		private static final long serialVersionUID = 1L;
		Parsing(String json, JSONException e) {
			super(clip(json, 280), e);
		}
		/**
		 * Convenience to shorten a potentially long string.
		 */
		private static String clip(String json, int len) {
			return json==null? null : 
				json.length()<=len? json : json.substring(len)+"...";
		}		
	}

	private static final long serialVersionUID = 1L;

	public FoursquareException(Exception e) {
		super(e);
	}

	public FoursquareException(String msg, Exception e) {
		super(msg, e);
	}

}
