package winterwell.j4square;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * 
 * The name is to distinguish from other User classes, since it's a common
 * name for a class.
 * 
 * @author daniel
 *
 */
public class User4Sq extends A4SqObj {
		
	public final String photo;
	public final String firstName;
	public final String lastName;
	public final String phone;
	public final String email;
	public final String twitter;
	private String gender;
	public final boolean friend;
	public final String facebook;

	User4Sq(JSONObject uo) throws JSONException {
		super(uo);
		firstName = uo.optString("firstname");
		lastName = uo.optString("lastname");
		// Name can be blank - fill it in sensibly
		if (name==null || name.length()==0) {
			if (firstName!=null && lastName!=null) name = firstName+" "+lastName;
			else if (firstName != null) name = firstName;
			else name = lastName;
		}
		phone = uo.optString("phone");
		email = uo.optString("email");
		twitter = uo.optString("twitter");
		facebook = uo.optString("facebook");
		photo = uo.optString("photo");
		gender = uo.optString("gender");
		String fs = uo.optString("friendstatus");
		friend = fs==null? false : fs.equals("self")? true : Boolean.valueOf(fs);
	}

	@Override
	public String toString() {
		return name;
	}
}
