package winterwell.j4square;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import winterwell.j4square.J4Square.Locn;

public class Venue extends A4SqObj {
	
	private String twitter;
	private String zip;
	private String phone;
	private String address;
	private String state;
	private String city;
	private String crossStreet;

	final double longitude;
	final double latitude;
	private transient int distance;
	
	Venue(JSONObject jsonObj) throws JSONException {
		super(jsonObj);
		twitter = jsonObj.optString("twitter");
		zip = jsonObj.optString("zip");
		phone = jsonObj.optString("phone");
		longitude = jsonObj.getDouble("geolong");
		latitude = jsonObj.getDouble("geolat");		
//		primarycategory={"id":79283,"nodename":"Train Station","iconurl":"http://foursquare.com/img/categories/travel/trainstation.png","fullpathname":"Travel:Train Station"},
		address = jsonObj.optString("address"); 
		state= jsonObj.optString("state");
		city=jsonObj.optString("city");
		crossStreet = jsonObj.optString("crossstreet");
		distance = jsonObj.optInt("distance");
		// TODO Auto-generated constructor stub
		/*
		 *             id:34655,
            name:'Monday Room',
            primarycategory:{
                id:79156,
                fullpathname:'Nightlife:Cocktails / Mixology',
                nodename:'Cocktails / Mixology',
                iconurl:'http://foursquare.com/img/categories/nightlife/cocktails.png'
            },
            address:'201 Elizabeth St',
            crossstreet:'btw Prince & Spring',
            city:'New York',
            state:'NY',
            zip:10012,
            geolat:40.722,
            geolong:-73.9944,
            phone:2123437011

		 */
	}

	public Venue(String id, String name, Locn location) {
		super(id, name);
		if (location==null) {
			this.latitude = Double.NaN;
			this.longitude = Double.NaN;
			return;
		}
		this.latitude = location.latitude;
		this.longitude = location.longitude;
	}

	static List<Venue> parse(String json) {
		try {
			List<Venue> list = new ArrayList<Venue>();
			JSONObject jo = new JSONObject(json);
			JSONArray vs = jo.optJSONArray("venues");
			if (vs != null) {
				parse2(list, vs);
				return list;
			}
			JSONArray grps = jo.getJSONArray("groups");			
			for(int i=0; i<grps.length(); i++) {
				JSONObject grp = grps.getJSONObject(i);
				JSONArray arr = grp.getJSONArray("venues");
				// e.g. Nearby Do we care?
				String type = grp.optString("type");
				parse2(list, arr);
			}
			return list;
		} catch (JSONException e) {
			throw new FoursquareException.Parsing(json, e);
		}
	}

	private static void parse2(List<Venue> list, JSONArray arr) throws JSONException {
		for(int j=0; j<arr.length(); j++) {
			JSONObject vjo = arr.getJSONObject(j);
			Venue venue = new Venue(vjo);
			list.add(venue);
		}
	}

}
