/*
 * Decompiled with CFR 0.152.
 */
package com.winterwell.jgeoplanet;

import com.winterwell.jgeoplanet.AdminRegion;
import com.winterwell.jgeoplanet.GeoPlanet;
import com.winterwell.jgeoplanet.GeoPlanetException;
import com.winterwell.jgeoplanet.GeoPlanetResource;
import com.winterwell.jgeoplanet.Location;
import com.winterwell.jgeoplanet.PlaceCollection;
import com.winterwell.jgeoplanet.PlaceType;
import org.json.JSONException;
import org.json.JSONObject;

public class Place
extends GeoPlanetResource {
    private final long woeId;
    private final String name;
    private final PlaceType placeType;
    private final String placeTypeNameVariant;
    private String postal;
    private String locality1;
    private String locality2;
    private AdminRegion country;
    private AdminRegion admin1;
    private AdminRegion admin2;
    private AdminRegion admin3;
    private Location centroid;
    private Location southWest;
    private Location northEast;

    Place(GeoPlanet client, JSONObject place) throws GeoPlanetException {
        super(client);
        try {
            this.woeId = place.getLong("woeid");
            this.name = place.getString("name");
            this.placeTypeNameVariant = place.getString("placeTypeName");
            int placeTypeCode = place.getJSONObject("placeTypeName attrs").getInt("code");
            this.placeType = client.getPlaceType(placeTypeCode);
            if (!place.has("postal")) {
                return;
            }
            this.postal = place.getString("postal");
            this.locality1 = place.getString("locality1");
            this.locality2 = place.getString("locality2");
            this.country = this.getAdminRegion(place, "country");
            this.admin1 = this.getAdminRegion(place, "admin1");
            this.admin2 = this.getAdminRegion(place, "admin2");
            this.admin3 = this.getAdminRegion(place, "admin3");
            this.centroid = new Location(place.getJSONObject("centroid"));
            JSONObject bbox = place.getJSONObject("boundingBox");
            this.southWest = new Location(bbox.getJSONObject("southWest"));
            this.northEast = new Location(bbox.getJSONObject("northEast"));
        }
        catch (JSONException e) {
            throw new GeoPlanetException((Exception)((Object)e));
        }
    }

    private AdminRegion getAdminRegion(JSONObject place, String field) throws JSONException {
        String admin = place.getString(field);
        if (admin.equals("")) {
            return null;
        }
        return new AdminRegion(this.getClient(), place, field);
    }

    public boolean isLongForm() {
        return this.centroid != null;
    }

    public Place getLongForm() throws GeoPlanetException {
        if (this.isLongForm()) {
            return this;
        }
        return this.getClient().getPlace(this.woeId);
    }

    public long getWoeId() {
        return this.woeId;
    }

    public String getName() {
        return this.name;
    }

    public PlaceType getPlaceType() {
        return this.placeType;
    }

    public String getPlaceTypeNameVariant() {
        return this.placeTypeNameVariant;
    }

    public String getLocality1() {
        return this.locality1;
    }

    public String getLocality2() {
        return this.locality2;
    }

    public Location getCentroid() {
        return this.centroid;
    }

    public Location getSouthWest() {
        return this.southWest;
    }

    public Location getNorthEast() {
        return this.northEast;
    }

    public boolean contains(Location location) {
        return location.containedIn(this.northEast, this.southWest);
    }

    public boolean contains(Place other) {
        return other.northEast.containedIn(this.northEast, this.southWest) && other.southWest.containedIn(this.northEast, this.southWest);
    }

    public String getPostal() {
        return this.postal;
    }

    public AdminRegion getCountry() {
        return this.country;
    }

    public AdminRegion getAdmin1() {
        return this.admin1;
    }

    public AdminRegion getAdmin2() {
        return this.admin2;
    }

    public AdminRegion getAdmin3() {
        return this.admin3;
    }

    public Place getParent() throws GeoPlanetException {
        StringBuilder uri = new StringBuilder("/place/");
        uri.append(this.woeId);
        uri.append("/parent");
        JSONObject parent = this.getClient().doGet(uri.toString(), false);
        try {
            return new Place(this.getClient(), parent.getJSONObject("place"));
        }
        catch (JSONException e) {
            throw new GeoPlanetException((Exception)((Object)e));
        }
    }

    public PlaceCollection getChildren() {
        return new PlaceCollection(this, "children");
    }

    public PlaceCollection getNeighbors() {
        return new PlaceCollection(this, "neighbors");
    }

    public PlaceCollection getSiblings() {
        return new PlaceCollection(this, "siblings");
    }

    public PlaceCollection getAncestors() {
        return new PlaceCollection(this, "ancestors");
    }

    public PlaceCollection getBelongTos() {
        return new PlaceCollection(this, "belongtos");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.woeId ^ this.woeId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Place other = (Place)obj;
        return this.woeId == other.woeId;
    }

    public String toString() {
        return "Place [name=" + this.name + ", " + "placeTypeName=" + this.placeTypeNameVariant + ", " + "placeType=" + this.placeType + ", " + "woeId=" + this.woeId + "]";
    }
}

