/*
 * Decompiled with CFR 0.152.
 */
package com.winterwell.jgeoplanet;

import com.winterwell.jgeoplanet.GeoPlanet;
import com.winterwell.jgeoplanet.GeoPlanetException;
import com.winterwell.jgeoplanet.GeoPlanetResource;
import com.winterwell.jgeoplanet.InvalidPlaceType;
import com.winterwell.jgeoplanet.Place;
import com.winterwell.jgeoplanet.PlaceType;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PlaceCollection
extends GeoPlanetResource {
    Place base;
    String query;
    PlaceType type;
    boolean useShortForm = false;
    int total = -1;

    PlaceCollection(GeoPlanet client, String query) {
        super(client);
        this.query = query;
    }

    PlaceCollection(Place place, String relation) {
        super(place.getClient());
        this.base = place;
        this.query = relation;
    }

    PlaceCollection(PlaceCollection other) {
        super(other.getClient());
        this.base = other.base;
        this.query = other.query;
        this.useShortForm = other.useShortForm;
        this.total = other.total;
    }

    public PlaceCollection type(PlaceType type) {
        if (type.equals(this.type)) {
            return this;
        }
        PlaceCollection variant = new PlaceCollection(this);
        variant.type = type;
        variant.total = -1;
        return variant;
    }

    public PlaceCollection type(String placeTypeName) throws InvalidPlaceType {
        return this.type(this.getClient().getPlaceType(placeTypeName));
    }

    public PlaceType getType() {
        return this.type;
    }

    public PlaceCollection shortForm(boolean useShortForm) {
        if (useShortForm == this.useShortForm) {
            return this;
        }
        PlaceCollection variant = new PlaceCollection(this);
        variant.useShortForm = useShortForm;
        return variant;
    }

    public boolean isShortForm() {
        return this.useShortForm;
    }

    private void appendType(StringBuilder sb) {
        assert (this.type != null);
        sb.append(".type(");
        sb.append(this.type.getName());
        sb.append(")");
    }

    private void appendQuery(StringBuilder sb) {
        assert (this.query != null);
        sb.append(".q(");
        sb.append(this.query);
        sb.append(")");
    }

    public int size() {
        return this.total;
    }

    public List<Place> get(int start, int count) throws GeoPlanetException {
        if (start < 0) {
            throw new IllegalArgumentException("start parameter must be >= 0");
        }
        if (count < 0) {
            throw new IllegalArgumentException("count parameter must be >= 0");
        }
        assert (count >= 0);
        StringBuilder uri = new StringBuilder();
        if (this.base == null) {
            uri = new StringBuilder("/places");
            if (this.type != null && this.query != null) {
                uri.append("$and(");
                this.appendQuery(uri);
                uri.append(",");
                this.appendType(uri);
                uri.append(")");
            } else if (this.query != null) {
                this.appendQuery(uri);
            } else if (this.type != null) {
                this.appendType(uri);
            }
        } else {
            uri = new StringBuilder("/place/");
            uri.append(this.base.getWoeId());
            uri.append("/");
            uri.append(this.query);
            if (this.type != null) {
                this.appendType(uri);
            }
        }
        uri.append(";start=");
        uri.append(start);
        uri.append(";count=");
        uri.append(count);
        JSONObject tmp = this.getClient().doGet(uri.toString(), this.useShortForm);
        return this.processResults(tmp);
    }

    public List<Place> get() throws GeoPlanetException {
        return this.get(0, 0);
    }

    public Place get(int index) throws GeoPlanetException {
        return this.get(index, 1).get(0);
    }

    private List<Place> processResults(JSONObject tmp) throws GeoPlanetException {
        try {
            tmp = tmp.getJSONObject("places");
            this.total = tmp.getInt("total");
            if (this.total == 0) {
                return new ArrayList<Place>(0);
            }
            int start = tmp.getInt("start");
            int count = tmp.getInt("count");
            assert (start >= 0);
            assert (count >= 0);
            assert (start + count <= this.total);
            ArrayList<Place> results = new ArrayList<Place>(count);
            JSONArray array = tmp.getJSONArray("place");
            for (int i = 0; i < count; ++i) {
                results.add(new Place(this.getClient(), array.getJSONObject(i)));
            }
            return results;
        }
        catch (JSONException e) {
            throw new GeoPlanetException((Exception)((Object)e));
        }
    }
}

