/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter;

import com.winterwell.json.JSONArray;
import com.winterwell.json.JSONException;
import com.winterwell.json.JSONObject;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import winterwell.jtwitter.InternalUtils;
import winterwell.jtwitter.Message;
import winterwell.jtwitter.Status;
import winterwell.jtwitter.StreamGobbler;
import winterwell.jtwitter.Twitter;
import winterwell.jtwitter.TwitterEvent;
import winterwell.jtwitter.TwitterException;
import winterwell.jtwitter.Twitter_Users;
import winterwell.jtwitter.User;

public abstract class AStream
implements Closeable {
    public static int MAX_BUFFER = 10000;
    private static final int MAX_WAIT_SECONDS = 600;
    final String LOGTAG = this.getClass().getSimpleName();
    boolean autoReconnect;
    final Twitter.IHttpClient client;
    List<TwitterEvent> events = new ArrayList<TwitterEvent>();
    boolean fillInFollows = true;
    private int forgotten;
    List<Number> friends;
    final Twitter jtwit;
    private BigInteger lastId = BigInteger.ZERO;
    private BigInteger lastDMId = BigInteger.ZERO;
    final List<IListen> listeners = new ArrayList<IListen>(0);
    final List<Outage> outages = Collections.synchronizedList(new ArrayList());
    int previousCount;
    StreamGobbler readThread;
    InputStream stream;
    List<Object[]> sysEvents = new ArrayList<Object[]>();
    List<Twitter.ITweet> tweets = new ArrayList<Twitter.ITweet>();
    boolean listenersOnly;

    static int forgetIfFull(List list) {
        if (list.size() < MAX_BUFFER) {
            return 0;
        }
        int n = MAX_BUFFER / 10;
        for (int i = 0; i < n; ++i) {
            Object e = list.remove(0);
            try {
                if (!(e instanceof Twitter.ITweet)) continue;
                Twitter.ITweet iTweet = (Twitter.ITweet)e;
                BigInteger bigInteger = iTweet.getId();
                String string = iTweet.getUser().getScreenName();
                InternalUtils.log("twitter.forget", bigInteger + " @" + string + ": " + iTweet.getText());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    static Object read3_parse(JSONObject jSONObject, Twitter twitter) throws JSONException {
        if (jSONObject.has("text")) {
            Status status = new Status(jSONObject, null);
            return status;
        }
        if (jSONObject.has("direct_message")) {
            Message message = new Message(jSONObject.getJSONObject("direct_message"));
            return message;
        }
        String string = jSONObject.optString("event");
        if (string != "") {
            TwitterEvent twitterEvent = new TwitterEvent(jSONObject, twitter);
            return twitterEvent;
        }
        JSONObject jSONObject2 = jSONObject.optJSONObject("delete");
        if (jSONObject2 != null) {
            boolean bl = false;
            JSONObject jSONObject3 = jSONObject2.optJSONObject("status");
            if (jSONObject3 == null) {
                jSONObject3 = jSONObject2.getJSONObject("direct_message");
                bl = true;
            }
            BigInteger bigInteger = new BigInteger(jSONObject3.getString("id_str"));
            BigInteger bigInteger2 = new BigInteger(jSONObject3.getString("user_id"));
            User user = new User(null, bigInteger2);
            Twitter.ITweet iTweet = bl ? new Message(user, bigInteger) : new Status(user, null, bigInteger, null);
            return new Object[]{"delete", iTweet, bigInteger2};
        }
        JSONObject jSONObject4 = jSONObject.optJSONObject("limit");
        if (jSONObject4 != null) {
            int n = jSONObject4.optInt("track");
            if (n == 0) {
                System.out.println(jSONObject);
            }
            return new Object[]{"limit", n};
        }
        JSONObject jSONObject5 = jSONObject.optJSONObject("disconnect");
        if (jSONObject5 != null) {
            return new Object[]{"disconnect", jSONObject5};
        }
        System.out.println(jSONObject);
        return new Object[]{"unknown", jSONObject};
    }

    public AStream(Twitter twitter) {
        this.client = twitter.getHttpClient();
        this.jtwit = twitter;
        this.client.setTimeout(91000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IListen iListen) {
        List<IListen> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(iListen);
            this.listeners.add(0, iListen);
        }
    }

    public void addOutage(Outage outage) {
        for (int i = 0; i < this.outages.size(); ++i) {
            Outage outage2 = this.outages.get(i);
            if (outage2.sinceId.compareTo(outage.sinceId) <= 0) continue;
            this.outages.add(i, outage);
            return;
        }
        this.outages.add(outage);
    }

    public void clear() {
        this.outages.clear();
        this.popEvents();
        this.popSystemEvents();
        this.popTweets();
    }

    @Override
    public synchronized void close() {
        if (this.readThread != null && Thread.currentThread() != this.readThread) {
            this.readThread.pleaseStop();
            if (this.readThread.isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.readThread.interrupt();
            }
            this.readThread = null;
        }
        InternalUtils.close(this.stream);
        this.stream = null;
    }

    public synchronized void connect() throws TwitterException {
        if (this.isConnected()) {
            return;
        }
        InternalUtils.log(this.LOGTAG, "connect()... " + this);
        this.close();
        assert (this.readThread == null || this.readThread.stream == this) : this;
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.connect2();
            this.stream = httpURLConnection.getInputStream();
            if (this.readThread == null) {
                this.readThread = new StreamGobbler(this);
                this.readThread.setName("Gobble:" + this.toString());
                this.readThread.start();
            } else {
                assert (Thread.currentThread() == this.readThread) : this;
                assert (this.readThread.stream == this) : this.readThread;
            }
            if (this.isConnected()) {
                return;
            }
            Thread.sleep(10L);
            if (!this.isConnected()) {
                throw new TwitterException(this.readThread.ex);
            }
        }
        catch (Exception exception) {
            InternalUtils.log(this.LOGTAG, "connect() error: " + exception);
            if (exception instanceof TwitterException) {
                throw (TwitterException)exception;
            }
            throw new TwitterException(exception);
        }
    }

    abstract HttpURLConnection connect2() throws Exception;

    public final Exception fillInOutages() throws UnsupportedOperationException {
        if (this.outages.size() == 0) {
            return null;
        }
        Outage[] outageArray = this.outages.toArray(new Outage[0]);
        Twitter twitter = new Twitter(this.jtwit);
        Exception exception = null;
        for (Outage outage : outageArray) {
            if (System.currentTimeMillis() - outage.untilTime < 20000L) continue;
            InternalUtils.log(this.LOGTAG, "attempted outage fill for " + outage + " for " + this);
            boolean bl = this.outages.remove(outage);
            if (!bl) {
                InternalUtils.log(this.LOGTAG, "outage registers already done for " + outage + " for " + this);
                continue;
            }
            if (System.currentTimeMillis() - outage.untilTime > 3600000L) {
                InternalUtils.log(this.LOGTAG, "Fail :( Giving up on old outage " + outage + " from " + new Date(outage.untilTime) + " for " + this);
                continue;
            }
            try {
                twitter.setSinceId(InternalUtils.addTimeToStatusId(outage.sinceId, -5000L));
                twitter.setUntilId(InternalUtils.addTimeToStatusId(outage.untilId, 5000L));
                twitter.setUntilDate(new Date(outage.untilTime));
                twitter.setMaxResults(100000);
                int n = this.fillInOutages2(twitter, outage);
                InternalUtils.log(this.LOGTAG, "outage fill for " + outage + " found: " + n + " for " + this);
            }
            catch (Throwable throwable) {
                this.outages.add(outage);
                InternalUtils.log(this.LOGTAG, "outage fill for " + outage + " error: " + throwable + " for " + this);
                exception = throwable instanceof Exception ? (Exception)throwable : new RuntimeException(throwable);
            }
        }
        return exception;
    }

    abstract int fillInOutages2(Twitter var1, Outage var2);

    protected void finalize() throws Throwable {
        this.close();
    }

    public final List<TwitterEvent> getEvents() {
        this.read();
        return this.events;
    }

    public final int getForgotten() {
        return this.forgotten;
    }

    public final List<Outage> getOutages() {
        return this.outages;
    }

    public final List<Object[]> getSystemEvents() {
        this.read();
        return this.sysEvents;
    }

    public final List<Twitter.ITweet> getTweets() {
        this.read();
        return this.tweets;
    }

    public final boolean isAlive() {
        if (this.isConnected()) {
            return true;
        }
        if (!this.autoReconnect) {
            return false;
        }
        return this.readThread != null && this.readThread.isAlive() && !this.readThread.stopFlag;
    }

    public final boolean isConnected() {
        boolean bl;
        boolean bl2 = bl = this.readThread != null && this.readThread.isAlive() && this.readThread.ex == null && !this.readThread.stopFlag;
        if (bl) {
            return true;
        }
        try {
            if (this.readThread == null) {
                InternalUtils.log(this.LOGTAG, "not Connected!? Details : readThread is NULL!");
            } else if (this.readThread.ex == null) {
                InternalUtils.log(this.LOGTAG, "not Connected!? Details :  readThread: " + this.readThread + " readThread.isAlive(): " + this.readThread.isAlive() + " readThread.stopFlag: " + this.readThread.stopFlag);
            } else {
                InternalUtils.log(this.LOGTAG, "not Connected!? Exception: " + this.readThread.ex);
            }
        }
        catch (Throwable throwable) {
            InternalUtils.log(this.LOGTAG, "not Connected - Logging failed!");
        }
        return false;
    }

    public final List<TwitterEvent> popEvents() {
        List<TwitterEvent> list = this.getEvents();
        this.events = new ArrayList<TwitterEvent>();
        return list;
    }

    public final List<Object[]> popSystemEvents() {
        List<Object[]> list = this.getSystemEvents();
        this.sysEvents = new ArrayList<Object[]>();
        return list;
    }

    public final List<Twitter.ITweet> popTweets() {
        List<Twitter.ITweet> list = this.getTweets();
        this.tweets = new ArrayList<Twitter.ITweet>();
        return list;
    }

    private final void read() {
        String[] stringArray;
        if (this.readThread != null) {
            for (String string : stringArray = this.readThread.popJsons()) {
                try {
                    this.read2(string);
                }
                catch (JSONException jSONException) {
                    throw new TwitterException.Parsing(string, jSONException);
                }
            }
        }
        if (this.isConnected()) {
            return;
        }
        if (this.readThread != null && this.readThread.stopFlag) {
            return;
        }
        stringArray = this.readThread == null ? null : this.readThread.ex;
        this.close();
        if (!this.autoReconnect) {
            if (stringArray instanceof TwitterException) {
                throw (TwitterException)stringArray;
            }
            throw new TwitterException((Exception)stringArray);
        }
        InternalUtils.log(this.LOGTAG, this + " disconnected: " + (String)(stringArray == null ? "no exception" : (Exception)stringArray + " " + stringArray.getStackTrace()));
        this.reconnect();
    }

    private void read2(String string) throws JSONException {
        JSONObject jSONObject = new JSONObject(string);
        JSONArray jSONArray = jSONObject.optJSONArray("friends");
        if (jSONArray != null) {
            this.read3_friends(jSONArray);
            return;
        }
        Object object = AStream.read3_parse(jSONObject, this.jtwit);
        if (object instanceof Twitter.ITweet) {
            Twitter.ITweet iTweet = (Twitter.ITweet)object;
            if (this.tweets.contains(iTweet)) {
                return;
            }
            this.tweets.add(iTweet);
            BigInteger bigInteger = iTweet.getId();
            if (iTweet instanceof Status) {
                if (bigInteger.compareTo(this.lastId) > 0) {
                    this.setLastId(bigInteger);
                }
            } else if (iTweet instanceof Message && bigInteger.compareTo(this.lastDMId) > 0) {
                this.setLastDMId(bigInteger);
            }
            this.forgotten += AStream.forgetIfFull(this.tweets);
            return;
        }
        if (object instanceof TwitterEvent) {
            TwitterEvent twitterEvent = (TwitterEvent)object;
            this.events.add(twitterEvent);
            this.forgotten += AStream.forgetIfFull(this.events);
            return;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            if ("delete".equals(objectArray[0])) {
                Twitter.ITweet iTweet = (Twitter.ITweet)objectArray[1];
                boolean bl = this.tweets.remove(iTweet);
                if (bl) {
                    return;
                }
            } else if ("limit".equals(objectArray[0])) {
                Integer n = (Integer)objectArray[1];
                this.forgotten += n.intValue();
            }
            this.sysEvents.add(objectArray);
            this.forgotten += AStream.forgetIfFull(this.sysEvents);
            return;
        }
        System.out.println(jSONObject);
    }

    private void setLastId(BigInteger bigInteger) {
        this.lastId = bigInteger;
        for (Outage outage : this.outages) {
            if (outage.untilId != null) continue;
            outage.untilId = bigInteger;
        }
    }

    private void setLastDMId(BigInteger bigInteger) {
        this.lastDMId = bigInteger;
        for (Outage outage : this.outages) {
            if (outage.untilDMId != null) continue;
            outage.untilDMId = bigInteger;
        }
    }

    private void read3_friends(JSONArray jSONArray) throws JSONException {
        List<Number> list = this.friends;
        this.friends = new ArrayList<Number>(jSONArray.length());
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            long l = jSONArray.getLong(i);
            this.friends.add(l);
        }
        if (this.friends == null || this.friends.isEmpty() || !this.fillInFollows) {
            return;
        }
        HashSet<Number> hashSet = new HashSet<Number>(this.friends);
        if (list != null) {
            hashSet.removeAll(list);
        }
        if (hashSet.size() == 0) {
            return;
        }
        Twitter_Users twitter_Users = new Twitter_Users(this.jtwit);
        List<User> list2 = twitter_Users.showById(hashSet);
        User user = this.jtwit.getSelf();
        for (User user2 : list2) {
            TwitterEvent twitterEvent = new TwitterEvent(new Date(), user, "follow", user2, null);
            this.events.add(twitterEvent);
        }
        this.forgotten += AStream.forgetIfFull(this.events);
    }

    synchronized void reconnect() {
        InternalUtils.log(this.LOGTAG, this + " reconnect()...");
        long l = System.currentTimeMillis();
        this.reconnect2();
        long l2 = System.currentTimeMillis() - l;
        this.addSysEvent(new Object[]{"reconnect", l2});
        if (this.lastId != BigInteger.ZERO || this.lastDMId != BigInteger.ZERO) {
            this.outages.add(new Outage(this.lastId, this.lastDMId, l, System.currentTimeMillis()));
            if (this.outages.size() > MAX_BUFFER) {
                int n = AStream.forgetIfFull(this.outages);
                this.forgotten += 10 * n;
            }
        }
        InternalUtils.log(this.LOGTAG, this + " ...reconnect() done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSysEvent(Object[] objectArray) {
        InternalUtils.log(this.LOGTAG, "sysEvent: " + InternalUtils.str(objectArray) + " for " + this);
        this.sysEvents.add(objectArray);
        if (this.listeners.size() == 0) {
            return;
        }
        List<IListen> list = this.listeners;
        synchronized (list) {
            try {
                IListen iListen;
                boolean bl;
                Iterator<IListen> iterator = this.listeners.iterator();
                while (iterator.hasNext() && (bl = (iListen = iterator.next()).processSystemEvent(objectArray))) {
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void reconnect2() {
        try {
            Thread.sleep(10L);
            this.connect();
            return;
        }
        catch (TwitterException.E40X e40X) {
            throw e40X;
        }
        catch (Exception exception) {
            int n = 20 + new Random().nextInt(40);
            int n2 = 0;
            while (n2 < 600) {
                try {
                    Thread.sleep(n * 1000);
                    n2 += n;
                    if (n < 300) {
                        n *= 2;
                    }
                    this.connect();
                    return;
                }
                catch (TwitterException.E40X e40X) {
                    throw e40X;
                }
                catch (Exception exception2) {
                    InternalUtils.log(this.LOGTAG, "Unknown exception occurring: is called:" + InternalUtils.str(exception2));
                }
            }
            throw new TwitterException.E50X("Could not connect to streaming server");
        }
    }

    synchronized void reconnectFromGobblerThread() {
        assert (Thread.currentThread() == this.readThread || this.readThread == null) : this;
        if (this.isConnected()) {
            return;
        }
        this.reconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(IListen iListen) {
        List<IListen> list = this.listeners;
        synchronized (list) {
            return this.listeners.remove(iListen);
        }
    }

    public void setAutoReconnect(boolean bl) {
        this.autoReconnect = bl;
    }

    @Deprecated
    public void setPreviousCount(int n) {
        this.previousCount = n;
    }

    public static final class Outage
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final BigInteger sinceId;
        BigInteger untilId;
        public final long untilTime;
        public final long sinceTime;
        public final BigInteger sinceDMId;
        BigInteger untilDMId;

        public Outage(BigInteger bigInteger, BigInteger bigInteger2, long l, long l2) {
            this.sinceId = bigInteger;
            this.sinceDMId = bigInteger2;
            this.untilTime = l2;
            this.sinceTime = l;
        }

        public String toString() {
            return "Outage[dt:" + (this.untilTime - this.sinceTime) / 1000L + "s id:" + this.sinceId + " to time:" + this.untilTime + " untilId:" + this.untilId + "]";
        }
    }

    public static interface IListen {
        public boolean processEvent(TwitterEvent var1) throws Exception;

        public boolean processSystemEvent(Object[] var1) throws Exception;

        public boolean processTweet(Twitter.ITweet var1) throws Exception;
    }
}

