/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter;

import com.winterwell.json.JSONArray;
import com.winterwell.json.JSONObject;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import winterwell.jtwitter.Place;
import winterwell.jtwitter.Status;
import winterwell.jtwitter.Twitter;
import winterwell.jtwitter.User;

public final class Message
implements Twitter.ITweet {
    private static final long serialVersionUID = 1L;
    private final Date createdAt;
    private EnumMap<Twitter.KEntityType, List<Twitter.TweetEntity>> entities;
    public final Number id;
    public Number inReplyToMessageId;
    private String location;
    private Place place;
    private User recipient;
    private User sender;
    private final BigInteger recipientId;
    private final BigInteger senderId;
    public final String text;

    @Override
    public String getDisplayText() {
        return Status.getDisplayText2(this);
    }

    public static List<Message> getMessages(JSONArray jSONArray) {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        for (JSONObject jSONObject : jSONArray) {
            if (JSONObject.NULL.equals(jSONObject)) continue;
            JSONObject jSONObject2 = jSONObject;
            Message message = new Message(jSONObject2);
            arrayList.add(message);
        }
        return arrayList;
    }

    Message(User user, Number number) {
        this.sender = user;
        this.id = number;
        this.recipient = null;
        this.createdAt = null;
        this.text = null;
        this.senderId = BigInteger.valueOf(user.id);
        this.recipientId = null;
    }

    public Message(JSONObject jSONObject) {
        String string = jSONObject.getString("id");
        this.id = new BigInteger(string);
        String string2 = jSONObject.getString("created_timestamp");
        this.createdAt = new Date();
        this.createdAt.setTime(Long.parseLong(string2));
        JSONObject jSONObject2 = jSONObject.getJSONObject("message_create");
        this.senderId = new BigInteger(jSONObject2.getString("sender_id"));
        JSONObject jSONObject3 = jSONObject2.getJSONObject("target");
        this.recipientId = new BigInteger(jSONObject3.getString("recipient_id"));
        JSONObject jSONObject4 = jSONObject2.getJSONObject("message_data");
        this.text = jSONObject4.getString("text");
        JSONObject jSONObject5 = jSONObject.optJSONObject("entities");
        if (jSONObject5 != null) {
            this.entities = new EnumMap(Twitter.KEntityType.class);
            for (Twitter.KEntityType kEntityType : Twitter.KEntityType.values()) {
                ArrayList<Twitter.TweetEntity> arrayList = Twitter.TweetEntity.parse(this, this.text, kEntityType, jSONObject5);
                this.entities.put(kEntityType, arrayList);
            }
        }
    }

    public void setPeople(JSONObject jSONObject) {
        this.sender = new User(jSONObject.getJSONObject(this.senderId.toString()), null);
        this.recipient = new User(jSONObject.getJSONObject(this.recipientId.toString()), null);
    }

    public void setPeople(User user, User user2) {
        this.sender = user;
        this.recipient = user2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Message message = (Message)object;
        return this.id.equals(message.id);
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public BigInteger getId() {
        if (this.id instanceof Long) {
            return BigInteger.valueOf(this.id.longValue());
        }
        return (BigInteger)this.id;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public List<String> getMentions() {
        return Collections.singletonList(this.recipient.screenName);
    }

    @Override
    public Place getPlace() {
        return this.place;
    }

    public User getRecipient() {
        return this.recipient;
    }

    public User getSender() {
        return this.sender;
    }

    public Number getSenderId() {
        return this.senderId;
    }

    public Number getRecipientId() {
        return this.recipientId;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public List<Twitter.TweetEntity> getTweetEntities(Twitter.KEntityType kEntityType) {
        return this.entities == null ? null : this.entities.get((Object)kEntityType);
    }

    @Override
    public User getUser() {
        return this.getSender();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.text;
    }
}

