/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter;

import com.winterwell.jgeoplanet.BoundingBox;
import com.winterwell.jgeoplanet.IGeoCode;
import com.winterwell.jgeoplanet.IPlace;
import com.winterwell.jgeoplanet.Location;
import com.winterwell.json.JSONArray;
import com.winterwell.json.JSONException;
import com.winterwell.json.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import winterwell.jtwitter.InternalUtils;

public class Place
implements IPlace,
Serializable {
    private static final long serialVersionUID = 1L;
    private BoundingBox boundingBox;
    private String country;
    private String countryCode;
    private List<Location> geometry;
    private String id;
    private String name;
    private String type;
    private Place parent;
    Class<? extends IGeoCode> geocoder;

    @Override
    public IPlace getParent() {
        return this.parent;
    }

    @Override
    public Class<? extends IGeoCode> getGeoCoder() {
        return this.geocoder;
    }

    public Place(JSONObject jSONObject, IGeoCode iGeoCode) throws JSONException {
        List<Location> list;
        Object object;
        this.geocoder = iGeoCode == null ? null : iGeoCode.getClass();
        this.id = InternalUtils.jsonGet("id", jSONObject);
        if (this.id == null) {
            this.id = InternalUtils.jsonGet("woeid", jSONObject);
        }
        this.type = InternalUtils.jsonGet("place_type", jSONObject);
        this.name = InternalUtils.jsonGet("full_name", jSONObject);
        if (this.name == null) {
            this.name = InternalUtils.jsonGet("name", jSONObject);
        }
        this.countryCode = InternalUtils.jsonGet("country_code", jSONObject);
        this.country = InternalUtils.jsonGet("country", jSONObject);
        Object object2 = jSONObject.opt("contained_within");
        if (object2 instanceof JSONArray) {
            object = (JSONArray)object2;
            Object object3 = object2 = ((JSONArray)object).length() == 0 ? null : ((JSONArray)object).get(0);
        }
        if (object2 != null) {
            this.parent = new Place((JSONObject)object2, iGeoCode);
        }
        if ((object = jSONObject.opt("bounding_box")) instanceof JSONObject) {
            list = this.parseCoords((JSONObject)object);
            double d = -90.0;
            double d2 = -180.0;
            double d3 = 90.0;
            double d4 = 180.0;
            for (Location location : list) {
                d = Math.max(location.latitude, d);
                d3 = Math.min(location.latitude, d3);
                d2 = Math.max(location.longitude, d2);
                d4 = Math.min(location.longitude, d4);
            }
            this.boundingBox = new BoundingBox(new Location(d, d2), new Location(d3, d4));
        }
        if ((list = jSONObject.opt("geometry")) instanceof JSONObject) {
            this.geometry = this.parseCoords((JSONObject)((Object)list));
        }
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public String getCountryCode() {
        return this.countryCode;
    }

    public String getCountryName() {
        return this.country;
    }

    public List<Location> getGeometry() {
        return this.geometry;
    }

    public String getId() {
        return this.id;
    }

    public String getInfoUrl() {
        return "http://api.twitter.com/1/geo/id/" + this.id + ".json";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    private List<Location> parseCoords(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = jSONObject.getJSONArray("coordinates");
        jSONArray = jSONArray.getJSONArray(0);
        ArrayList<Location> arrayList = new ArrayList<Location>();
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            JSONArray jSONArray2 = jSONArray.getJSONArray(i);
            Location location = new Location(jSONArray2.getDouble(1), jSONArray2.getDouble(0));
            arrayList.add(location);
        }
        return arrayList;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Location getCentroid() {
        if (this.boundingBox == null) {
            return null;
        }
        return this.boundingBox.getCenter();
    }

    @Override
    public String getUID() {
        return this.id + "@twitter";
    }
}

