/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter;

import com.winterwell.json.JSONException;
import com.winterwell.json.JSONObject;
import java.util.Date;
import winterwell.jtwitter.InternalUtils;
import winterwell.jtwitter.Status;
import winterwell.jtwitter.Twitter;
import winterwell.jtwitter.TwitterList;
import winterwell.jtwitter.User;

public class TwitterEvent {
    public final Date createdAt;
    public final User source;
    public final User target;
    private Object targetObject;
    public final String type;

    TwitterEvent(Date date, User user, String string, User user2, Object object) {
        this.createdAt = date;
        this.source = user;
        this.type = string;
        this.target = user2;
        this.targetObject = object;
    }

    public TwitterEvent(JSONObject jSONObject, Twitter twitter) throws JSONException {
        this.type = jSONObject.getString("event");
        this.target = new User(jSONObject.getJSONObject("target"), null);
        this.source = new User(jSONObject.getJSONObject("source"), null);
        this.createdAt = InternalUtils.parseDate(jSONObject.getString("created_at"));
        JSONObject jSONObject2 = jSONObject.optJSONObject("target_object");
        if (jSONObject2 == null) {
            return;
        }
        if (jSONObject2.has("member_count")) {
            this.targetObject = new TwitterList(jSONObject2, twitter);
            return;
        }
        try {
            this.targetObject = new Status(jSONObject2, null);
        }
        catch (Exception exception) {
            this.targetObject = jSONObject2;
        }
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public User getSource() {
        return this.source;
    }

    public User getTarget() {
        return this.target;
    }

    public Object getTargetObject() {
        return this.targetObject;
    }

    public String getType() {
        return this.type;
    }

    public boolean is(String string) {
        return this.type.equals(string);
    }

    public String toString() {
        return this.source + " " + this.type + " " + this.target + " " + this.getTargetObject();
    }

    public static interface Type {
        public static final String ADDED_TO_LIST = "list_member_added";
        public static final String FAVORITE = "favorite";
        public static final String FOLLOW = "follow";
        public static final String LIST_CREATED = "list_created";
        public static final String REMOVED_FROM_LIST = "list_member_removed";
        public static final String UNFAVORITE = "unfavorite";
        public static final String USER_UPDATE = "user_update";
    }
}

