/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter.ecosystem;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import winterwell.jtwitter.InternalUtils;
import winterwell.jtwitter.Status;
import winterwell.jtwitter.Twitter;
import winterwell.jtwitter.TwitterException;
import winterwell.jtwitter.URLConnectionHttpClient;

public class TwitLonger {
    Twitter.IHttpClient http;
    private Twitter jtwit;
    private String twitlongerApiKey;
    private String twitlongerAppName;
    static final Pattern contentTag = Pattern.compile("<content>(.+?)<\\/content>", 32);
    static final Pattern idTag = Pattern.compile("<id>(.+?)<\\/id>", 32);

    public TwitLonger() {
        this.http = new URLConnectionHttpClient();
    }

    public TwitLonger(Twitter twitter, String string, String string2) {
        this.twitlongerApiKey = string;
        this.twitlongerAppName = string2;
        this.http = twitter.getHttpClient();
        this.jtwit = twitter;
        if (string == null || string2 == null) {
            throw new IllegalStateException("Incomplete Twitlonger api details");
        }
    }

    public Status updateLongStatus(String string, Number number) {
        String string2;
        Matcher matcher;
        boolean bl;
        assert (this.twitlongerApiKey != null) : "Wrong constructor used -- you must supply an api-key to post";
        if (string.length() < 141) {
            throw new IllegalArgumentException("Message too short (" + number + " chars). Just post a normal Twitter status. ");
        }
        String string3 = "http://www.twitlonger.com/api_post";
        Map map = InternalUtils.asMap("application", this.twitlongerAppName, "api_key", this.twitlongerApiKey, "username", this.jtwit.getScreenName(), "message", string);
        if (number != null && number.doubleValue() != 0.0) {
            map.put("in_reply", number.toString());
        }
        if (!(bl = (matcher = contentTag.matcher(string2 = this.http.post(string3, map, false))).find())) {
            throw new TwitterException.TwitLongerException("TwitLonger call failed", string2);
        }
        String string4 = matcher.group(1).trim();
        Status status = this.jtwit.updateStatus(string4, number);
        matcher = idTag.matcher(string2);
        bl = matcher.find();
        if (!bl) {
            return status;
        }
        String string5 = matcher.group(1);
        try {
            string3 = "http://www.twitlonger.com/api_set_id";
            map.remove("message");
            map.remove("in_reply");
            map.remove("username");
            map.put("message_id", string5);
            map.put("twitter_id", "" + status.getId());
            this.http.post(string3, map, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return status;
    }

    public String getLongStatus(Status status) {
        int n = status.text.indexOf("http://tl.gd/");
        if (n == -1) {
            return status.text;
        }
        String string = status.text.substring(n + 13).trim();
        String string2 = this.http.getPage("http://www.twitlonger.com/api_read/" + string, null, false);
        Matcher matcher = contentTag.matcher(string2);
        boolean bl = matcher.find();
        if (!bl) {
            throw new TwitterException.TwitLongerException("TwitLonger call failed", string2);
        }
        String string3 = matcher.group(1).trim();
        return string3;
    }
}

