/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter.guts;

import java.io.ByteArrayOutputStream;

public final class Base64Encoder {
    static final char[] charTab = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    public static String encode(String string) {
        return Base64Encoder.encode(string.getBytes()).toString();
    }

    public static String encode(byte[] byArray) {
        return Base64Encoder.encode(byArray, 0, byArray.length, null).toString();
    }

    public static StringBuilder encode(byte[] byArray, int n, int n2, StringBuilder stringBuilder) {
        int n3;
        int n4;
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(byArray.length * 3 / 2);
        }
        int n5 = n2 - 3;
        int n6 = 0;
        for (n4 = n; n4 <= n5; n4 += 3) {
            n3 = (byArray[n4] & 0xFF) << 16 | (byArray[n4 + 1] & 0xFF) << 8 | byArray[n4 + 2] & 0xFF;
            stringBuilder.append(charTab[n3 >> 18 & 0x3F]);
            stringBuilder.append(charTab[n3 >> 12 & 0x3F]);
            stringBuilder.append(charTab[n3 >> 6 & 0x3F]);
            stringBuilder.append(charTab[n3 & 0x3F]);
            if (n6++ < 14) continue;
            n6 = 0;
            stringBuilder.append("\r\n");
        }
        if (n4 == n + n2 - 2) {
            n3 = (byArray[n4] & 0xFF) << 16 | (byArray[n4 + 1] & 0xFF) << 8;
            stringBuilder.append(charTab[n3 >> 18 & 0x3F]);
            stringBuilder.append(charTab[n3 >> 12 & 0x3F]);
            stringBuilder.append(charTab[n3 >> 6 & 0x3F]);
            stringBuilder.append("=");
        } else if (n4 == n + n2 - 1) {
            n3 = (byArray[n4] & 0xFF) << 16;
            stringBuilder.append(charTab[n3 >> 18 & 0x3F]);
            stringBuilder.append(charTab[n3 >> 12 & 0x3F]);
            stringBuilder.append("==");
        }
        return stringBuilder;
    }

    static int decode(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 26 + 26;
        }
        switch (c) {
            case '+': {
                return 62;
            }
            case '/': {
                return 63;
            }
            case '=': {
                return 0;
            }
        }
        throw new RuntimeException("unexpected code: " + c);
    }

    public static byte[] decode(String string) {
        int n = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = string.length();
        while (true) {
            if (n < n2 && string.charAt(n) <= ' ') {
                ++n;
                continue;
            }
            if (n == n2) break;
            int n3 = (Base64Encoder.decode(string.charAt(n)) << 18) + (Base64Encoder.decode(string.charAt(n + 1)) << 12) + (Base64Encoder.decode(string.charAt(n + 2)) << 6) + Base64Encoder.decode(string.charAt(n + 3));
            byteArrayOutputStream.write(n3 >> 16 & 0xFF);
            if (string.charAt(n + 2) == '=') break;
            byteArrayOutputStream.write(n3 >> 8 & 0xFF);
            if (string.charAt(n + 3) == '=') break;
            byteArrayOutputStream.write(n3 & 0xFF);
            n += 4;
        }
        return byteArrayOutputStream.toByteArray();
    }
}

