/*
 * Decompiled with CFR 0.152.
 */
package com.winterwell.jgeoplanet;

import com.winterwell.jgeoplanet.BoundingBox;
import com.winterwell.jgeoplanet.IPlace;
import com.winterwell.jgeoplanet.Location;
import winterwell.jtwitter.InternalUtils;

public class GeoCodeQuery {
    public boolean reqLocn;
    public boolean reqGeometry;
    public boolean reqOnlyCity;
    public boolean reqOnlyCountry;
    public String desc;
    public Location locn;
    public BoundingBox bbox;
    public String country;
    public String city;
    public String lang;
    public String timezone;
    public String type;

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.country == null ? 0 : this.country.hashCode());
        n = 31 * n + (this.desc == null ? 0 : this.desc.hashCode());
        n = 31 * n + (this.lang == null ? 0 : this.lang.hashCode());
        n = 31 * n + (this.locn == null ? 0 : this.locn.hashCode());
        n = 31 * n + (this.reqGeometry ? 1231 : 1237);
        n = 31 * n + (this.reqLocn ? 1231 : 1237);
        n = 31 * n + (this.reqOnlyCity ? 1231 : 1237);
        n = 31 * n + (this.reqOnlyCountry ? 1231 : 1237);
        n = 31 * n + (this.timezone == null ? 0 : this.timezone.hashCode());
        n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        GeoCodeQuery geoCodeQuery = (GeoCodeQuery)object;
        if (this.country == null ? geoCodeQuery.country != null : !this.country.equals(geoCodeQuery.country)) {
            return false;
        }
        if (this.desc == null ? geoCodeQuery.desc != null : !this.desc.equals(geoCodeQuery.desc)) {
            return false;
        }
        if (this.lang == null ? geoCodeQuery.lang != null : !this.lang.equals(geoCodeQuery.lang)) {
            return false;
        }
        if (this.locn == null ? geoCodeQuery.locn != null : !this.locn.equals(geoCodeQuery.locn)) {
            return false;
        }
        if (this.reqGeometry != geoCodeQuery.reqGeometry) {
            return false;
        }
        if (this.reqLocn != geoCodeQuery.reqLocn) {
            return false;
        }
        if (this.reqOnlyCity != geoCodeQuery.reqOnlyCity) {
            return false;
        }
        if (this.reqOnlyCountry != geoCodeQuery.reqOnlyCountry) {
            return false;
        }
        if (this.timezone == null ? geoCodeQuery.timezone != null : !this.timezone.equals(geoCodeQuery.timezone)) {
            return false;
        }
        return !(this.type == null ? geoCodeQuery.type != null : !this.type.equals(geoCodeQuery.type));
    }

    public String toString() {
        return "GeoCodeQuery[" + InternalUtils.or(this.desc, this.city, this.country, this.locn, this.timezone) + "]";
    }

    public GeoCodeQuery() {
    }

    public GeoCodeQuery(String string) {
        this.desc = string;
    }

    public GeoCodeQuery(IPlace iPlace) {
        this.setLocation(iPlace.getCentroid());
        if (this.locn == null) {
            this.desc = iPlace.getName();
        }
        this.country = iPlace.getCountryCode();
        this.bbox = iPlace.getBoundingBox();
    }

    public String getCountryCode() {
        return this.country;
    }

    public BoundingBox getBoundingBox() {
        return this.bbox;
    }

    public boolean isEmpty() {
        return !(this.desc != null && !this.desc.isEmpty() || this.locn != null || this.bbox != null || this.city != null || this.country != null || this.timezone != null && this.lang != null);
    }

    public GeoCodeQuery setReqLocn(boolean bl) {
        this.reqLocn = bl;
        return this;
    }

    public GeoCodeQuery setLocation(Location location) {
        this.locn = location;
        return this;
    }

    public GeoCodeQuery setLatitudeLongitude(double d, double d2) {
        this.setLocation(new Location(d, d2));
        return this;
    }
}

