/*
 * Decompiled with CFR 0.152.
 */
package com.winterwell.jgeoplanet;

import com.winterwell.jgeoplanet.Dx;
import com.winterwell.jgeoplanet.LengthUnit;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import winterwell.jtwitter.InternalUtils;

public class Location
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final double DIAMETER_OF_EARTH = 1.27562E7;
    public final double longitude;
    public final double latitude;
    public static final Pattern latLongLocn = Pattern.compile("(\\S+:)?\\s*(-?[\\d\\.]*\\d),\\s*(-?[\\d\\.]*\\d)\\.?\\s*");

    public Location(double d, double d2) throws IllegalArgumentException {
        if (d < -90.0 || d > 90.0) {
            throw new IllegalArgumentException("Invalid latitude: " + d + ", " + d2);
        }
        if (d2 < -180.0 || d2 > 180.0) {
            if ((d2 %= 360.0) > 180.0) {
                d2 = 360.0 - d2;
            } else if (d2 < -180.0) {
                d2 += 360.0;
            }
            assert (d2 >= -180.0 || d2 <= 180.0) : d2;
        }
        this.latitude = d;
        this.longitude = d2;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double[] getLatLong() {
        return new double[]{this.latitude, this.longitude};
    }

    public double getLongitude() {
        return this.longitude;
    }

    public Dx distance(Location location) {
        double d = this.latitude * Math.PI / 180.0;
        double d2 = this.longitude * Math.PI / 180.0;
        double d3 = location.latitude * Math.PI / 180.0;
        double d4 = location.longitude * Math.PI / 180.0;
        double d5 = Math.sin((d - d3) / 2.0);
        d5 *= d5;
        double d6 = Math.sin((d2 - d4) / 2.0);
        d6 *= d6;
        double d7 = 1.27562E7 * Math.asin(Math.sqrt(d5 + Math.cos(d) * Math.cos(d3) * d6));
        return new Dx(d7, LengthUnit.METRE);
    }

    public Location move(double d, double d2) {
        double d3 = 6378100.0;
        double d4 = d / d3;
        double d5 = d2 / (d3 * Math.cos(Math.PI * this.latitude / 180.0));
        double d6 = this.latitude + d4 * 180.0 / Math.PI;
        double d7 = this.longitude + d5 * 180.0 / Math.PI;
        return new Location(d6, d7);
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.latitude);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.longitude);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Location location = (Location)object;
        if (Double.doubleToLongBits(this.latitude) != Double.doubleToLongBits(location.latitude)) {
            return false;
        }
        return Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(location.longitude);
    }

    public String toString() {
        return "(" + this.latitude + " N, " + this.longitude + " E)";
    }

    public String toSimpleCoords() {
        return this.latitude + "," + this.longitude;
    }

    public static Location parse(String string) {
        Matcher matcher = latLongLocn.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String string2 = matcher.group(2);
        String string3 = matcher.group(3);
        try {
            double d = Double.valueOf(string2);
            if (Math.abs(d) > 90.0) {
                return null;
            }
            return new Location(d, Double.valueOf(string3));
        }
        catch (NumberFormatException numberFormatException) {
            InternalUtils.log("Location.parse", string + " " + numberFormatException);
            return null;
        }
    }
}

