/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter;

import com.winterwell.json.JSONArray;
import com.winterwell.json.JSONException;
import com.winterwell.json.JSONObject;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import winterwell.jtwitter.InternalUtils;
import winterwell.jtwitter.Place;
import winterwell.jtwitter.Twitter;
import winterwell.jtwitter.TwitterException;
import winterwell.jtwitter.Twitter_Geo;
import winterwell.jtwitter.User;

public final class Status
implements Twitter.ITweet {
    static final Pattern AT_YOU_SIR = Pattern.compile("@(\\w+)");
    private static final String FAKE = "fake";
    private static final long serialVersionUID = 1L;
    public final Date createdAt;
    private EnumMap<Twitter.KEntityType, List<Twitter.TweetEntity>> entities;
    private boolean favorited;
    public final BigInteger id;
    public final BigInteger inReplyToStatusId;
    private String location;
    private Status original;
    private Place place;
    public final int retweetCount;
    public final int favoriteCount;
    boolean sensitive;
    public final String source;
    public final String text;
    public final User user;
    private String lang;
    private transient String _rawtext;
    private boolean retweet;
    private boolean quotedStatus;
    private int displayStart;
    private int displayEnd;
    private transient JSONObject raw;
    private static final Pattern RT_AUTHOR = Pattern.compile("RT @([^: ]+):");

    public static List<Status> getStatuses(String string) throws TwitterException {
        if (string.trim().equals("")) {
            return Collections.emptyList();
        }
        try {
            JSONArray jSONArray = new JSONArray(string);
            return Status.getStatuses(jSONArray);
        }
        catch (JSONException jSONException) {
            if (string.startsWith("<")) {
                throw new TwitterException.E50X(InternalUtils.stripTags(string));
            }
            throw new TwitterException.Parsing(string, jSONException);
        }
    }

    public static List<Status> getStatuses(JSONArray jSONArray) throws TwitterException {
        ArrayList<Status> arrayList = new ArrayList<Status>();
        for (JSONObject jSONObject : jSONArray) {
            if (JSONObject.NULL.equals(jSONObject)) continue;
            JSONObject jSONObject2 = jSONObject;
            Status status = new Status(jSONObject2, null);
            arrayList.add(status);
        }
        return arrayList;
    }

    static List<Status> getStatusesFromSearch(Twitter twitter, String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            ArrayList<Status> arrayList = new ArrayList<Status>();
            JSONArray jSONArray = jSONObject.getJSONArray("statuses");
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                Status status = new Status(jSONObject2, null);
                arrayList.add(status);
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string, jSONException);
        }
    }

    static Object jsonGetLocn(JSONObject jSONObject) throws JSONException {
        Object object = InternalUtils.jsonGet("location", jSONObject);
        if (object != null && ((String)object).length() == 0) {
            object = null;
        }
        JSONObject jSONObject2 = jSONObject.optJSONObject("place");
        if (object != null) {
            Matcher matcher = InternalUtils.latLongLocn.matcher((CharSequence)object);
            if (matcher.matches()) {
                object = matcher.group(2) + "," + matcher.group(3);
            }
            return object;
        }
        if (jSONObject2 != null) {
            Place place = new Place(jSONObject2, null);
            place.geocoder = Twitter_Geo.class;
            return place;
        }
        JSONObject jSONObject3 = jSONObject.optJSONObject("geo");
        if (jSONObject3 != null && jSONObject3 != JSONObject.NULL) {
            JSONArray jSONArray = jSONObject3.getJSONArray("coordinates");
            object = jSONArray.get(0) + "," + jSONArray.get(1);
        }
        return object;
    }

    public boolean isRetweet() {
        return this.retweet;
    }

    public boolean isQuotedStatus() {
        return this.quotedStatus;
    }

    public String getLang() {
        return this.lang;
    }

    public Status(JSONObject jSONObject, User user) throws TwitterException {
        this.raw = jSONObject;
        try {
            String string;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            String string2 = jSONObject.optString("id_str");
            this.id = new BigInteger(string2 == "" ? jSONObject.get("id").toString() : string2);
            this._rawtext = InternalUtils.jsonGet("full_text", jSONObject);
            if (this._rawtext == null) {
                this._rawtext = InternalUtils.jsonGet("text", jSONObject);
            }
            JSONObject jSONObject2 = jSONObject.optJSONObject("entities");
            Object object6 = jSONObject.optJSONArray("display_text_range");
            JSONObject jSONObject3 = jSONObject.optJSONObject("extended_tweet");
            if (jSONObject3 != null) {
                object5 = jSONObject3.optString("full_text");
                if (object5 != null) {
                    this._rawtext = object5;
                }
                if ((object4 = jSONObject3.optJSONObject("entities")) != null) {
                    jSONObject2 = object4;
                }
                if ((object3 = jSONObject3.optJSONArray("display_text_range")) != null) {
                    object6 = object3;
                }
            }
            if (object6 != null) {
                object5 = ((JSONArray)object6).optInt(0);
                if (object5 != null) {
                    this.displayStart = (Integer)object5;
                }
                if ((object4 = Integer.valueOf(((JSONArray)object6).optInt(0))) != null) {
                    this.displayEnd = (Integer)object4;
                }
            }
            if ((object5 = jSONObject.optJSONObject("retweeted_status")) != null) {
                this.retweet = true;
                if (((JSONObject)object5).has("user")) {
                    this.original = new Status((JSONObject)object5, null);
                } else {
                    object4 = RT_AUTHOR.matcher(this._rawtext);
                    if (((Matcher)object4).find()) {
                        object3 = ((Matcher)object4).group(1);
                        object2 = new User((String)object3);
                        this.original = new Status((JSONObject)object5, (User)object2);
                    } else {
                        this.original = new Status((JSONObject)object5, null);
                    }
                }
            }
            if ((object4 = jSONObject.optJSONObject("quoted_status")) != null) {
                this.quotedStatus = true;
                try {
                    this.original = new Status((JSONObject)object4, null);
                }
                catch (Throwable throwable) {
                    InternalUtils.log("bad.json", "Quoted status could not be parsed: " + throwable);
                }
            }
            object3 = this._rawtext;
            object2 = null;
            if (this.original != null && ((String)object3).startsWith("RT ")) {
                object2 = "RT @" + this.original.getUser() + ": ";
                object3 = (String)object2 + this.original.getText();
            } else {
                object3 = InternalUtils.unencode((String)object3);
            }
            this.text = object3;
            String string3 = InternalUtils.jsonGet("created_at", jSONObject);
            this.createdAt = InternalUtils.parseDate(string3);
            String string4 = InternalUtils.jsonGet("source", jSONObject);
            this.source = string4 != null && string4.contains("&lt;") ? InternalUtils.unencode(string4) : string4;
            String string5 = InternalUtils.jsonGet("in_reply_to_status_id", jSONObject);
            this.inReplyToStatusId = string5 == null || string5.length() == 0 ? (this.original == null ? null : this.original.getId()) : new BigInteger(string5);
            this.favorited = jSONObject.optBoolean("favorited");
            if (user != null) {
                this.user = user;
            } else {
                object = jSONObject.optJSONObject("user");
                if (object == null) {
                    this.user = null;
                } else if (((JSONObject)object).opt("screen_name") == null) {
                    string = ((JSONObject)object).optString("id_str");
                    BigInteger bigInteger = new BigInteger(string == "" ? jSONObject.get("id").toString() : string);
                    this.user = new User(null, bigInteger);
                } else {
                    this.user = new User((JSONObject)object, this);
                }
            }
            object = Status.jsonGetLocn(jSONObject);
            String string6 = this.location = object == null ? null : object.toString();
            if (object instanceof Place) {
                this.place = (Place)object;
            }
            this.lang = "und".equals(string = jSONObject.optString("lang")) ? null : string;
            this.retweetCount = jSONObject.optInt("retweet_count", -1);
            this.favoriteCount = jSONObject.optInt("favorite_count", -1);
            if (jSONObject2 != null) {
                this.entities = new EnumMap(Twitter.KEntityType.class);
                this.setupEntities(this._rawtext, (String)object2, jSONObject2);
            }
            this.sensitive = jSONObject.optBoolean("possibly_sensitive");
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(null, jSONException);
        }
    }

    private void setupEntities(String string, String string2, JSONObject jSONObject) {
        if (string2 != null) {
            int n = string2.length();
            for (Twitter.KEntityType kEntityType : Twitter.KEntityType.values()) {
                List<Twitter.TweetEntity> list = this.original.getTweetEntities(kEntityType);
                if (list == null) continue;
                ArrayList<Twitter.TweetEntity> arrayList = new ArrayList<Twitter.TweetEntity>(list.size());
                for (Twitter.TweetEntity tweetEntity : list) {
                    Twitter.TweetEntity tweetEntity2 = new Twitter.TweetEntity((Twitter.ITweet)this, tweetEntity.type, Math.min(n + tweetEntity.start, this.text.length()), Math.min(n + tweetEntity.end, this.text.length()), tweetEntity.display);
                    arrayList.add(tweetEntity2);
                }
                this.entities.put(kEntityType, arrayList);
            }
            return;
        }
        for (Twitter.KEntityType kEntityType : Twitter.KEntityType.values()) {
            ArrayList<Twitter.TweetEntity> arrayList = Twitter.TweetEntity.parse(this, string, kEntityType, jSONObject);
            this.entities.put(kEntityType, arrayList);
        }
    }

    @Deprecated
    public Status(User user, String string, Number number, Date date) {
        this.text = string;
        this.user = user;
        this.createdAt = date;
        this.id = number == null ? null : (number instanceof BigInteger ? (BigInteger)number : new BigInteger(number.toString()));
        this.inReplyToStatusId = null;
        this.source = FAKE;
        this.retweetCount = -1;
        this.favoriteCount = -1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Status status = (Status)object;
        return this.id.equals(status.id);
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public BigInteger getId() {
        return this.id;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public List<String> getMentions() {
        Matcher matcher = AT_YOU_SIR.matcher(this.text);
        ArrayList<String> arrayList = new ArrayList<String>(2);
        while (matcher.find()) {
            if (matcher.start() != 0 && Character.isLetterOrDigit(this.text.charAt(matcher.start() - 1))) continue;
            String string = matcher.group(1);
            if (!Twitter.CASE_SENSITIVE_SCREENNAMES) {
                string = string.toLowerCase();
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public Status getOriginal() {
        return this.original;
    }

    @Override
    public Place getPlace() {
        return this.place;
    }

    public String getSource() {
        return InternalUtils.stripTags(this.source);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public List<Twitter.TweetEntity> getTweetEntities(Twitter.KEntityType kEntityType) {
        return this.entities == null ? null : this.entities.get((Object)kEntityType);
    }

    @Override
    public User getUser() {
        return this.user;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean isFavorite() {
        return this.favorited;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public String toString() {
        return this.text;
    }

    @Override
    public String getDisplayText() {
        return Status.getDisplayText2(this);
    }

    static String getDisplayText2(Twitter.ITweet iTweet) {
        try {
            List<Twitter.TweetEntity> list = iTweet.getTweetEntities(Twitter.KEntityType.urls);
            String string = iTweet.getText();
            IndexConverter indexConverter = new IndexConverter(string);
            if (list == null || list.size() == 0) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder(200);
            int n = 0;
            for (Twitter.TweetEntity tweetEntity : list) {
                if (tweetEntity.start < n) {
                    InternalUtils.log("jtwitter", "#escalate bogus entity ordering in " + iTweet.getId() + " " + tweetEntity + " in " + string);
                    continue;
                }
                if (n > string.length() || tweetEntity.start > string.length()) {
                    String string2 = iTweet instanceof Status ? ((Status)iTweet)._rawtext : null;
                    InternalUtils.log("jtwitter", "#escalate bogus entity in " + iTweet.getId() + " " + iTweet.getClass().getSimpleName() + " " + tweetEntity + " in " + string + " raw:" + string2);
                    continue;
                }
                stringBuilder.append(string.substring(n, indexConverter.codePointsToCodeUnits(tweetEntity.start)));
                stringBuilder.append(tweetEntity.displayVersion());
                n = indexConverter.codePointsToCodeUnits(tweetEntity.end);
            }
            if (n < string.length()) {
                stringBuilder.append(string.substring(n));
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            InternalUtils.log("tweet.text.error", "getDisplayText for " + iTweet.getClass() + " " + iTweet.getId() + " " + exception + " from " + iTweet.getText());
            return iTweet.getText();
        }
    }

    public String getUrl() {
        return "https://twitter.com/" + this.user.screenName + "/status/" + this.id;
    }

    private static final class IndexConverter {
        protected final String text;
        protected int codePointIndex = 0;
        protected int charIndex = 0;

        IndexConverter(String string) {
            this.text = string;
        }

        int codeUnitsToCodePoints(int n) {
            this.codePointIndex = n < this.charIndex ? (this.codePointIndex -= this.text.codePointCount(n, this.charIndex)) : (this.codePointIndex += this.text.codePointCount(this.charIndex, n));
            this.charIndex = n;
            if (n > 0 && Character.isSupplementaryCodePoint(this.text.codePointAt(n - 1))) {
                --this.charIndex;
            }
            return this.codePointIndex;
        }

        int codePointsToCodeUnits(int n) {
            this.charIndex = this.text.offsetByCodePoints(this.charIndex, n - this.codePointIndex);
            this.codePointIndex = n;
            return this.charIndex;
        }
    }
}

