/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter;

import com.winterwell.jgeoplanet.BoundingBox;
import com.winterwell.jgeoplanet.IPlace;
import com.winterwell.jgeoplanet.Location;
import com.winterwell.json.JSONArray;
import com.winterwell.json.JSONException;
import com.winterwell.json.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import winterwell.jtwitter.BearerAuthHttpClient;
import winterwell.jtwitter.InternalUtils;
import winterwell.jtwitter.Message;
import winterwell.jtwitter.OAuthSignpostClient;
import winterwell.jtwitter.Place;
import winterwell.jtwitter.RateLimit;
import winterwell.jtwitter.Regex;
import winterwell.jtwitter.Status;
import winterwell.jtwitter.TwitterException;
import winterwell.jtwitter.TwitterList;
import winterwell.jtwitter.Twitter_Account;
import winterwell.jtwitter.Twitter_Analytics;
import winterwell.jtwitter.Twitter_Geo;
import winterwell.jtwitter.Twitter_Users;
import winterwell.jtwitter.URLConnectionHttpClient;
import winterwell.jtwitter.User;
import winterwell.jtwitter.Webhooks;
import winterwell.jtwitter.ecosystem.TwitLonger;
import winterwell.jtwitter.guts.Base64Encoder;

public class Twitter
implements Serializable {
    public static boolean CASE_SENSITIVE_SCREENNAMES;
    public static boolean CHECK_TWEET_LENGTH;
    public static int LINK_LENGTH;
    public static int MEDIA_LENGTH;
    public static long PHOTO_SIZE_LIMIT;
    public static long VIDEO_SIZE_LIMIT;
    private static final long MAX_CHUNK_SIZE = 5120000L;
    public static final String SEARCH_MIXED = "mixed";
    public static final String SEARCH_POPULAR = "popular";
    public static final String SEARCH_RECENT = "recent";
    private static final long serialVersionUID = 1L;
    public static final String version = "3.8.6";
    public static final int MAX_CHARS = 280;
    static final String API_VERSION = "1.1";
    static final String DEFAULT_TWITTER_URL = "https://api.twitter.com/1.1";
    static final String TWITTER_UPLOAD_URL = "https://upload.twitter.com/1.1";
    static final String MEDIA_UPLOAD_ENDPOINT = "/media/upload.json";
    static final String DM_BASE_ENDPOINT = "/direct_messages/events";
    public static int MAX_DM_LENGTH;
    public static boolean WORRIED_ABOUT_TWITTER;
    Integer count;
    private String geocode;
    final IHttpClient http;
    private String appKey;
    private String appSecret;
    private String accessToken;
    boolean includeRTs = true;
    private String lang;
    private int maxResults = -1;
    private double[] myLatLong;
    private String name;
    private String resultType;
    User self;
    private Date sinceDate;
    private BigInteger sinceId;
    private String sourceApp = "jtwitterlib";
    boolean tweetEntities = true;
    boolean extendedMode = true;
    boolean autoPopulateReplyMetadata = true;
    @Deprecated
    private transient String twitlongerApiKey;
    @Deprecated
    private transient String twitlongerAppName;
    String TWITTER_URL = "https://api.twitter.com/1.1";
    private Date untilDate;
    private BigInteger untilId;
    private Long placeId;
    static final Pattern NID;

    public static Map<String, Double> getAPIStatus() throws Exception {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        String string = null;
        try {
            URLConnectionHttpClient uRLConnectionHttpClient = new URLConnectionHttpClient();
            string = uRLConnectionHttpClient.getPage("https://api.io.watchmouse.com/synth/current/39657/folder/7617/?fields=info;cur;24h.uptime", null, false);
            JSONObject jSONObject = new JSONObject(string);
            JSONArray jSONArray = jSONObject.getJSONArray("result");
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                String string2 = jSONObject2.getJSONObject("info").getString("name");
                JSONObject jSONObject3 = jSONObject2.getJSONObject("24h");
                double d = jSONObject3.getDouble("uptime");
                hashMap.put(string2, d);
            }
            return hashMap;
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string, jSONException);
        }
        catch (Exception exception) {
            return hashMap;
        }
    }

    public static User getUser(String string, List<User> list) {
        assert (string != null && list != null);
        for (User user : list) {
            if (!string.equals(user.screenName)) continue;
            return user;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 3) {
            Twitter twitter = new Twitter(stringArray[0], stringArray[1]);
            Status status = twitter.setStatus(stringArray[2]);
            System.out.println(status);
            return;
        }
        System.out.println("Java interface for Twitter");
        System.out.println("--------------------------");
        System.out.println("Version 3.8.6");
        System.out.println("Released under LGPL by Winterwell Associates Ltd.");
        System.out.println("See source code, JavaDoc, or http://winterwell.com for details on how to use.");
    }

    public void setMyPlace(Long l) {
        this.placeId = l;
    }

    public Twitter() {
        this(null, new URLConnectionHttpClient());
    }

    public Twitter(String string, IHttpClient iHttpClient) {
        this.name = string;
        this.http = iHttpClient;
        assert (iHttpClient != null);
    }

    @Deprecated
    public Twitter(String string, String string2) {
        this(string, new URLConnectionHttpClient(string, string2));
    }

    public Twitter(Twitter twitter) {
        this(twitter.getScreenName(), twitter.http.copy());
        this.accessToken = twitter.accessToken;
        this.appKey = twitter.appKey;
        this.appSecret = twitter.appSecret;
    }

    public Twitter_Account account() {
        return new Twitter_Account(this);
    }

    public Twitter_Analytics analytics() {
        return new Twitter_Analytics(this.http);
    }

    Map<String, String> addListParameters(Map<String, String> map) {
        if (this.sinceId != null && this.sinceId.doubleValue() != 0.0) {
            String string = this.sinceId.toString();
            map.put("since_id", string);
        }
        if (this.untilId != null) {
            map.put("max_id", this.untilId.toString());
        }
        if (this.count != null) {
            map.put("count", this.count.toString());
        }
        return map;
    }

    Map<String, String> addTweetParameters(Map<String, String> map) {
        if (this.tweetEntities) {
            map.put("include_entities", "1");
        } else {
            map.put("include_entities", "0");
        }
        if (!this.includeRTs) {
            map.put("include_rts", "0");
        }
        if (this.extendedMode) {
            map.put("tweet_mode", "extended");
        }
        return map;
    }

    Map<String, String> addStandardishParameters(Map<String, String> map) {
        this.addListParameters(map);
        this.addTweetParameters(map);
        return map;
    }

    @Deprecated
    public User befriend(String string) throws TwitterException {
        return this.follow(string);
    }

    @Deprecated
    public User breakFriendship(String string) {
        return this.stopFollowing(string);
    }

    public List<User> bulkShow(List<String> list) {
        return this.users().show(list);
    }

    public List<User> bulkShowById(List<? extends Number> list) {
        return this.users().showById(list);
    }

    private <T extends ITweet> List<T> dateFilter(List<T> list) {
        if (this.sinceDate == null && this.untilDate == null) {
            return list;
        }
        ArrayList<ITweet> arrayList = new ArrayList<ITweet>(list.size());
        for (ITweet iTweet : list) {
            if (iTweet.getCreatedAt() == null) {
                arrayList.add(iTweet);
                continue;
            }
            if (this.untilDate != null && this.untilDate.before(iTweet.getCreatedAt()) || this.sinceDate != null && this.sinceDate.after(iTweet.getCreatedAt())) continue;
            arrayList.add(iTweet);
        }
        return arrayList;
    }

    public void destroy(ITweet iTweet) throws TwitterException {
        if (iTweet instanceof Status) {
            this.destroyStatus(iTweet.getId());
        } else {
            this.destroyMessage((Message)iTweet);
        }
    }

    private void destroyMessage(Message message) {
        this.destroyMessage(message.id);
    }

    public void destroyMessage(Number number) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("id", number.toString());
        String string = this.post(this.TWITTER_URL + "/direct_messages/events/destroy.json", hashMap, true);
        assert (string != null);
    }

    public void destroyStatus(Number number) throws TwitterException {
        String string = this.post(this.TWITTER_URL + "/statuses/destroy/" + number + ".json", null, true);
        this.flush();
        assert (string != null);
    }

    @Deprecated
    public void destroyStatus(Status status) throws TwitterException {
        this.destroyStatus(status.getId());
    }

    boolean enoughResults(List list) {
        if (list.isEmpty()) {
            return false;
        }
        if (this.maxResults == -1) {
            return true;
        }
        return list.size() >= this.maxResults;
    }

    void flush() {
        this.http.getPage("https://twitter.com/" + this.name, null, true);
    }

    @Deprecated
    public User follow(String string) throws TwitterException {
        return this.users().follow(string);
    }

    public String toString() {
        return this.name == null ? "Twitter" : "Twitter[" + this.name + "]";
    }

    @Deprecated
    public User follow(User user) {
        return this.follow(user.screenName);
    }

    public Twitter_Geo geo() {
        return new Twitter_Geo(this);
    }

    public Message getDirectMessage(Number number) {
        boolean bl = InternalUtils.authoriseIn11(this);
        Map map = InternalUtils.asMap("id", number);
        String string = this.http.getPage(this.TWITTER_URL + "/direct_messages/events/show.json", map, bl);
        try {
            JSONObject jSONObject = new JSONObject(string);
            Message message = new Message(jSONObject.getJSONObject("event"));
            return message;
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string, jSONException);
        }
    }

    public List<Message> getDirectMessages() {
        InternalUtils.log("jtwitter.dm", "as:" + this.getScreenNameIfKnown() + "...");
        return this.getMessages(this.standardishParameters());
    }

    public List<Status> getFavorites() {
        return this.getFavorites(null);
    }

    public List<Status> getFavorites(String string) {
        Map map = InternalUtils.asMap("screen_name", string);
        return this.getStatuses(this.TWITTER_URL + "/favorites/list.json", this.addStandardishParameters(map), this.http.canAuthenticate());
    }

    @Deprecated
    public List<Number> getFollowerIDs() throws TwitterException {
        return this.users().getFollowerIDs();
    }

    @Deprecated
    public List<Number> getFollowerIDs(String string) throws TwitterException {
        return this.users().getFollowerIDs(string);
    }

    @Deprecated
    public List<User> getFollowers() throws TwitterException {
        return this.users().getFollowers();
    }

    @Deprecated
    public List<User> getFollowers(String string) throws TwitterException {
        return this.users().getFollowers(string);
    }

    @Deprecated
    public List<Number> getFriendIDs() throws TwitterException {
        return this.users().getFriendIDs();
    }

    @Deprecated
    public List<Number> getFriendIDs(String string) throws TwitterException {
        return this.users().getFriendIDs(string);
    }

    @Deprecated
    public List<User> getFriends() throws TwitterException {
        return this.users().getFriends();
    }

    @Deprecated
    public List<User> getFriends(String string) throws TwitterException {
        return this.users().getFriends(string);
    }

    @Deprecated
    public List<Status> getFriendsTimeline() throws TwitterException {
        return this.getHomeTimeline();
    }

    public List<Status> getHomeTimeline() throws TwitterException {
        assert (this.http.canAuthenticate());
        return this.getStatuses(this.TWITTER_URL + "/statuses/home_timeline.json", this.standardishParameters(), true);
    }

    public IHttpClient getHttpClient() {
        return this.http;
    }

    public List<TwitterList> getLists() {
        return this.getLists(this.name);
    }

    public List<TwitterList> getListsAll(User user) {
        assert (user != null || this.http.canAuthenticate()) : "No authenticating user";
        try {
            String string = this.TWITTER_URL + "/lists/all.json";
            Map map = user.screenName == null ? InternalUtils.asMap("user_id", user.id) : InternalUtils.asMap("screen_name", user.screenName);
            String string2 = this.http.getPage(string, map, this.http.canAuthenticate());
            JSONObject jSONObject = new JSONObject(string2);
            JSONArray jSONArray = (JSONArray)jSONObject.get("lists");
            ArrayList<TwitterList> arrayList = new ArrayList<TwitterList>();
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                TwitterList twitterList = new TwitterList(jSONObject2, this);
                arrayList.add(twitterList);
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(null, jSONException);
        }
    }

    public List<TwitterList> getLists(String string) {
        assert (string != null);
        try {
            String string2 = this.TWITTER_URL + "/lists/list.json";
            Map map = InternalUtils.asMap("screen_name", string);
            String string3 = this.http.getPage(string2, map, true);
            JSONArray jSONArray = new JSONArray(string3);
            ArrayList<TwitterList> arrayList = new ArrayList<TwitterList>();
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                TwitterList twitterList = new TwitterList(jSONObject, this);
                arrayList.add(twitterList);
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(null, jSONException);
        }
    }

    public List<TwitterList> getListsContaining(String string, boolean bl) {
        assert (string != null);
        try {
            String string2 = this.TWITTER_URL + "/lists/memberships.json";
            Map map = InternalUtils.asMap("screen_name", string);
            if (bl) {
                assert (this.http.canAuthenticate());
                map.put("filter_to_owned_lists", "1");
            }
            String string3 = this.http.getPage(string2, map, this.http.canAuthenticate());
            JSONObject jSONObject = new JSONObject(string3);
            JSONArray jSONArray = (JSONArray)jSONObject.get("lists");
            ArrayList<TwitterList> arrayList = new ArrayList<TwitterList>();
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                TwitterList twitterList = new TwitterList(jSONObject2, this);
                arrayList.add(twitterList);
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(null, jSONException);
        }
    }

    public List<TwitterList> getListsContainingMe() {
        return this.getListsContaining(this.name, false);
    }

    public String getLongStatus(Status status) {
        TwitLonger twitLonger = new TwitLonger();
        return twitLonger.getLongStatus(status);
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public List<Status> getMentions() {
        return this.getStatuses(this.TWITTER_URL + "/statuses/mentions_timeline.json", this.standardishParameters(), true);
    }

    private List<Message> getMessages(Map<String, String> map) {
        String string = this.TWITTER_URL + "/direct_messages/events/list.json";
        if (!map.containsKey("full_text")) {
            map.put("full_text", "true");
        }
        if (this.maxResults < 1) {
            String string2 = this.http.getPage(string, map, true);
            JSONObject jSONObject = new JSONObject(string2);
            JSONArray jSONArray = jSONObject.optJSONArray("events");
            if (jSONArray == null || jSONArray.length() == 0) {
                return new ArrayList<Message>();
            }
            List<Message> list = Message.getMessages(jSONArray);
            list = this.dateFilter(list);
            return list;
        }
        String string3 = null;
        ArrayList<Message> arrayList = new ArrayList<Message>();
        while (arrayList.size() <= this.maxResults) {
            String string4 = this.http.getPage(string, map, true);
            JSONObject jSONObject = new JSONObject(string4);
            JSONArray jSONArray = jSONObject.optJSONArray("events");
            string3 = jSONObject.optString("next_cursor");
            List<Message> list = Message.getMessages(jSONArray);
            List<Message> list2 = this.dateFilter(list);
            if (list2.isEmpty()) break;
            arrayList.addAll(list2);
            if (string3 == null || string3.isEmpty()) break;
            map.put("cursor", string3);
        }
        return arrayList;
    }

    public RateLimit getRateLimit(KRequestType kRequestType) {
        return this.http.getRateLimit(kRequestType);
    }

    public int getRateLimitStatus() {
        RateLimit rateLimit = ((URLConnectionHttpClient)this.http).updateRateLimits().get(KRequestType.NORMAL.rateLimit);
        return rateLimit == null ? 90 : rateLimit.getRemaining();
    }

    public List<Status> getReplies() throws TwitterException {
        return this.getMentions();
    }

    public List<User> getRetweeters(Status status) {
        String string = this.TWITTER_URL + "/statuses/retweets/" + status.id + ".json";
        Map<String, String> map = this.addStandardishParameters(new HashMap<String, String>());
        String string2 = this.http.getPage(string, map, this.http.canAuthenticate());
        List<Status> list = Status.getStatuses(string2);
        ArrayList<User> arrayList = new ArrayList<User>(list.size());
        for (Status status2 : list) {
            arrayList.add(status2.getUser());
        }
        return arrayList;
    }

    public List<Status> getRetweets(Status status) {
        String string = this.TWITTER_URL + "/statuses/retweets/" + status.id + ".json";
        Map<String, String> map = this.addStandardishParameters(new HashMap<String, String>());
        String string2 = this.http.getPage(string, map, true);
        List<Status> list = Status.getStatuses(string2);
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\"RT @" + status.getUser().getScreenName() + ": ");
            if (stringBuilder.length() + status.text.length() + 1 > 280) {
                int n = status.text.lastIndexOf(32, 280 - stringBuilder.length() - 1);
                String string3 = status.text.substring(0, n);
                stringBuilder.append(string3);
            } else {
                stringBuilder.append(status.text);
            }
            stringBuilder.append('\"');
            List<Status> list2 = this.search(stringBuilder.toString());
            list.addAll(list2);
            Collections.sort(list, InternalUtils.NEWEST_FIRST);
            return list;
        }
        catch (TwitterException twitterException) {
            return list;
        }
    }

    public List<Status> getRetweetsByMe() {
        List<Status> list = this.getUserTimeline();
        ArrayList<Status> arrayList = new ArrayList<Status>();
        for (Status status : list) {
            if (status.getOriginal() == null || !status.getText().startsWith("RT")) continue;
            arrayList.add(status);
        }
        return arrayList;
    }

    public List<Status> getRetweetsOfMe() {
        String string = this.TWITTER_URL + "/statuses/retweets_of_me.json";
        Map<String, String> map = this.addStandardishParameters(new HashMap<String, String>());
        String string2 = this.http.getPage(string, map, true);
        return Status.getStatuses(string2);
    }

    public String getScreenName() {
        if (this.name != null) {
            return this.name;
        }
        this.getSelf();
        return this.name;
    }

    public String getScreenNameIfKnown() {
        return this.name;
    }

    private Map<String, String> getSearchParams(String string, Integer n) {
        Map map = InternalUtils.asMap("count", n, "q", string);
        if (this.sinceId != null && this.sinceId.doubleValue() != 0.0) {
            map.put("since_id", this.sinceId.toString());
        }
        if (this.untilId != null) {
            map.put("max_id", this.untilId.toString());
        }
        if (this.untilDate != null) {
            map.put("until", InternalUtils.df.format(this.untilDate));
        }
        if (this.lang != null) {
            map.put("lang", this.lang);
        }
        if (this.geocode != null) {
            map.put("geocode", this.geocode);
        }
        if (this.resultType != null) {
            map.put("result_type", this.resultType);
        }
        this.addStandardishParameters(map);
        return map;
    }

    public User getSelf() {
        if (this.self != null) {
            return this.self;
        }
        if (!this.http.canAuthenticate()) {
            if (this.name != null) {
                this.self = new User(this.name);
                return this.self;
            }
            return null;
        }
        this.account().verifyCredentials();
        this.name = this.self.getScreenName();
        return this.self;
    }

    public Status getStatus() throws TwitterException {
        Map<String, String> map = this.standardishParameters();
        map.put("count", "6");
        String string = this.http.getPage(this.TWITTER_URL + "/statuses/user_timeline.json", map, true);
        List<Status> list = Status.getStatuses(string);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public Status getStatus(Number number) throws TwitterException {
        boolean bl = InternalUtils.authoriseIn11(this);
        Map<String, String> map = this.standardishParameters();
        String string = this.http.getPage(this.TWITTER_URL + "/statuses/show/" + number + ".json", map, bl);
        try {
            return new Status(new JSONObject(string), null);
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string, jSONException);
        }
    }

    public Status getStatus(String string) throws TwitterException {
        assert (string != null);
        Map<String, String> map = this.standardishParameters();
        map.put("id", string);
        map.put("count", "6");
        String string2 = this.http.getPage(this.TWITTER_URL + "/statuses/user_timeline.json", map, this.http.canAuthenticate());
        List<Status> list = Status.getStatuses(string2);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    List<Status> getStatuses(String string, Map<String, String> map, boolean bl) {
        if (this.maxResults < 1) {
            List<Status> list;
            try {
                list = Status.getStatuses(this.http.getPage(string, map, bl));
            }
            catch (TwitterException.Parsing parsing) {
                if (this.http.isRetryOnError()) {
                    InternalUtils.sleep(250L);
                    String string2 = this.http.getPage(string, map, bl);
                    list = Status.getStatuses(string2);
                }
                throw parsing;
            }
            list = this.dateFilter(list);
            return list;
        }
        BigInteger bigInteger = this.untilId;
        ArrayList<Status> arrayList = new ArrayList<Status>();
        while (arrayList.size() <= this.maxResults) {
            Object object;
            List<Status> list;
            Object object2;
            try {
                object2 = this.http.getPage(string, map, bl);
                list = Status.getStatuses((String)object2);
            }
            catch (TwitterException.Parsing parsing) {
                if (this.http.isRetryOnError()) {
                    InternalUtils.sleep(250L);
                    object = this.http.getPage(string, map, bl);
                    list = Status.getStatuses((String)object);
                }
                throw parsing;
            }
            if (list.size() == 0) break;
            bigInteger = InternalUtils.getMinId(bigInteger, list);
            object2 = InternalUtils.getMaxDate(list);
            object = this.dateFilter(list);
            arrayList.addAll((Collection<Status>)object);
            if (object.size() == 0 && this.sinceDate != null && this.sinceDate.after((Date)object2)) break;
            map.put("max_id", bigInteger.toString());
        }
        return arrayList;
    }

    public InputStream getDMImage(Message message) {
        List<TweetEntity> list = message.getTweetEntities(KEntityType.media);
        if (list.isEmpty()) {
            return null;
        }
        String string = list.get(0).mediaUrl();
        try {
            HttpURLConnection httpURLConnection = this.http.connect(string, null, true);
            return httpURLConnection.getInputStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public List<String> getTrends() {
        return this.getTrends(1);
    }

    public List<String> getTrends(Number number) {
        String string = this.http.getPage(this.TWITTER_URL + "/trends/place.json", InternalUtils.asMap("id", number), true);
        try {
            JSONArray jSONArray = new JSONArray(string);
            JSONObject jSONObject = jSONArray.getJSONObject(0);
            JSONArray jSONArray2 = jSONObject.getJSONArray("trends");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < jSONArray2.length(); ++i) {
                JSONObject jSONObject2 = jSONArray2.getJSONObject(i);
                String string2 = jSONObject2.getString("name");
                arrayList.add(string2);
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string, jSONException);
        }
    }

    public Date getUntilDate() {
        return this.untilDate;
    }

    @Deprecated
    public User getUser(long l) {
        return this.show(l);
    }

    @Deprecated
    public User getUser(String string) {
        return this.show(string);
    }

    public List<Status> getUserTimeline() throws TwitterException {
        return this.getStatuses(this.TWITTER_URL + "/statuses/user_timeline.json", this.standardishParameters(), true);
    }

    public List<Status> getUserTimeline(Long l) throws TwitterException {
        Map map = InternalUtils.asMap("user_id", l);
        this.addStandardishParameters(map);
        boolean bl = this.http.canAuthenticate();
        return this.getStatuses(this.TWITTER_URL + "/statuses/user_timeline.json", map, bl);
    }

    public List<Status> getUserTimeline(String string) throws TwitterException {
        Map map = InternalUtils.asMap("screen_name", string);
        this.addStandardishParameters(map);
        boolean bl = this.http.canAuthenticate();
        try {
            return this.getStatuses(this.TWITTER_URL + "/statuses/user_timeline.json", map, bl);
        }
        catch (TwitterException.E404 e404) {
            throw new TwitterException.E404("Twitter does not return any information for " + string + ". They may have been deleted long ago.");
        }
        catch (TwitterException.E401 e401) {
            this.isSuspended(string);
            throw e401;
        }
    }

    public List<Status> getUserTimelineWithRetweets(String string) throws TwitterException {
        Map map = InternalUtils.asMap("screen_name", string, "include_rts", "1");
        this.addStandardishParameters(map);
        boolean bl = this.http.canAuthenticate();
        try {
            return this.getStatuses(this.TWITTER_URL + "/statuses/user_timeline.json", map, bl);
        }
        catch (TwitterException.E401 e401) {
            this.isSuspended(string);
            throw e401;
        }
    }

    @Deprecated
    public boolean isFollower(String string) {
        return this.isFollower(string, this.name);
    }

    public boolean isFollower(String string, String string2) {
        return this.users().isFollower(string, string2);
    }

    @Deprecated
    public boolean isFollowing(String string) {
        return this.isFollower(this.name, string);
    }

    @Deprecated
    public boolean isFollowing(User user) {
        return this.isFollowing(user.screenName);
    }

    public boolean isRateLimited(KRequestType kRequestType, int n) {
        RateLimit rateLimit = this.getRateLimit(kRequestType);
        if (rateLimit == null) {
            return false;
        }
        if (rateLimit.getRemaining() >= n) {
            return false;
        }
        return !rateLimit.isOutOfDate();
    }

    private void isSuspended(String string) throws TwitterException.SuspendedUser {
        this.show(string);
    }

    public boolean isTwitlongerSetup() {
        return this.twitlongerApiKey != null && this.twitlongerAppName != null;
    }

    public boolean isValidLogin() {
        if (!this.http.canAuthenticate()) {
            return false;
        }
        try {
            Twitter_Account twitter_Account = new Twitter_Account(this);
            User user = twitter_Account.verifyCredentials();
            return true;
        }
        catch (TwitterException.E403 e403) {
            return false;
        }
        catch (TwitterException.E401 e401) {
            return false;
        }
        catch (TwitterException twitterException) {
            throw twitterException;
        }
    }

    private String post(String string, Map<String, String> map, boolean bl) throws TwitterException {
        String string2 = this.http.post(string, map, bl);
        return string2;
    }

    private String postJSON(String string, JSONObject jSONObject, boolean bl) throws TwitterException {
        String string2 = this.http.postJSON(string, jSONObject, bl);
        return string2;
    }

    public void reportSpam(String string) {
        this.http.getPage(this.TWITTER_URL + "/version/report_spam.json", InternalUtils.asMap("screen_name", string), true);
    }

    public Status retweet(Status status) {
        try {
            Map map = this.extendedMode ? InternalUtils.asMap("tweet_mode", "extended") : null;
            String string = this.post(this.TWITTER_URL + "/statuses/retweet/" + status.getId() + ".json", map, true);
            return new Status(new JSONObject(string), null);
        }
        catch (TwitterException.E403 e403) {
            List<Status> list = this.getRetweetsByMe();
            for (Status status2 : list) {
                if (!status.equals(status2.getOriginal())) continue;
                throw new TwitterException.Repetition(status2.getText());
            }
            throw e403;
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(null, jSONException);
        }
    }

    public void enableAppAuth(String string, String string2) {
        this.appKey = string;
        this.appSecret = string2;
    }

    public void enableAppAuth(String string) {
        this.accessToken = string;
    }

    private String getAccessToken() throws IllegalStateException, TwitterException {
        if (this.accessToken != null && !this.accessToken.isEmpty()) {
            return this.accessToken;
        }
        if (this.appKey == null || this.appKey.isEmpty() || this.appSecret == null || this.appSecret.isEmpty()) {
            throw new IllegalStateException("You must enable app-level auth by calling enableAppAuth() with the application key and secret or a previously-obtained access token before you use this method.");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("grant_type", "client_credentials");
        URLConnectionHttpClient uRLConnectionHttpClient = new URLConnectionHttpClient(this.appKey, this.appSecret);
        String string = uRLConnectionHttpClient.post("https://api.twitter.com/oauth2/token", hashMap, false);
        Object object = new JSONObject(string).get("access_token");
        this.accessToken = object.toString();
        return this.accessToken;
    }

    public BigInteger registerWebhook(String string, String string2) throws Exception {
        String string3 = this.TWITTER_URL + "/account_activity/all/" + string2 + "/webhooks.json";
        String string4 = this.http.post(string3 + "?url=" + InternalUtils.urlEncode(string), null, true);
        JSONObject jSONObject = new JSONObject(string4);
        return new BigInteger(jSONObject.getString("id"));
    }

    public void unregisterWebhook(BigInteger bigInteger, String string) throws TwitterException {
        String string2 = this.TWITTER_URL + "/account_activity/all/" + string + "/webhooks/" + bigInteger + ".json";
        this.http.delete(string2, true);
    }

    public void subscribeAccountActivity(String string) {
        this.http.post(this.TWITTER_URL + "/account_activity/all/" + string + "/subscriptions.json", null, true);
    }

    public void unsubscribeAccountActivity(String string) throws TwitterException {
        this.http.delete(this.TWITTER_URL + "/account_activity/all/" + string + "/subscriptions.json", true);
    }

    public Integer countAccountActivitySubscriptions(String string) {
        try {
            String string2 = this.getAccessToken();
            BearerAuthHttpClient bearerAuthHttpClient = new BearerAuthHttpClient();
            bearerAuthHttpClient.setBearerToken(string2);
            String string3 = bearerAuthHttpClient.getPage(this.TWITTER_URL + "/account_activity/all/subscriptions/count.json", null, true);
            JSONObject jSONObject = new JSONObject(string3);
            return jSONObject.getInt("subscriptions_count");
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return null;
        }
    }

    public List<Webhooks.Subscription> listAccountActivitySubscriptions(String string) throws TwitterException, IllegalStateException {
        String string2 = this.getAccessToken();
        BearerAuthHttpClient bearerAuthHttpClient = new BearerAuthHttpClient();
        bearerAuthHttpClient.setBearerToken(string2);
        String string3 = bearerAuthHttpClient.getPage(this.TWITTER_URL + "/account_activity/all/" + string + "/subscriptions/list.json", null, true);
        JSONObject jSONObject = new JSONObject(string3);
        Webhooks.SubscriptionList subscriptionList = new Webhooks.SubscriptionList(jSONObject);
        return subscriptionList.subscriptions;
    }

    public Webhooks.WebhookList getWebhooks() throws TwitterException, IllegalStateException {
        String string = this.getAccessToken();
        BearerAuthHttpClient bearerAuthHttpClient = new BearerAuthHttpClient();
        bearerAuthHttpClient.setBearerToken(string);
        String string2 = bearerAuthHttpClient.getPage(this.TWITTER_URL + "/account_activity/all/webhooks.json", null, true);
        JSONObject jSONObject = new JSONObject(string2);
        return new Webhooks.WebhookList(jSONObject);
    }

    public Status retweetWithComment(Status status, String string) {
        if (string == null) {
            return this.retweet(status);
        }
        if ((string = string.trim()).length() == 0) {
            return this.retweet(status);
        }
        Status status2 = this.setStatus(string + " " + status.getUrl());
        return status2;
    }

    public List<Status> search(String string) {
        return this.search(string, null, 100);
    }

    public List<Status> search(String string, ICallback iCallback, int n) {
        int n2;
        List<Status> list;
        if (n > 100 && this.maxResults < n) {
            throw new IllegalArgumentException("You need to switch on paging to fetch more than 100 search results. First call setMaxResults() to raise the limit above " + n);
        }
        if (string.length() > 1000) {
            throw new TwitterException.E406("Search query too long: " + string);
        }
        Map<String, String> map = this.maxResults < 100 && this.maxResults > 0 ? this.getSearchParams(string, this.maxResults) : this.getSearchParams(string, n);
        ArrayList<Status> arrayList = new ArrayList<Status>(Math.max(this.maxResults, n));
        String string2 = this.TWITTER_URL + "/search/tweets.json";
        BigInteger bigInteger = this.untilId;
        do {
            map.put("max_id", (String)((Object)bigInteger));
            try {
                String string3 = this.http.getPage(string2, map, true);
                list = Status.getStatusesFromSearch(this, string3);
            }
            catch (TwitterException.Parsing parsing) {
                if (this.http.isRetryOnError()) {
                    InternalUtils.sleep(250L);
                    String string4 = this.http.getPage(string2, map, true);
                    list = Status.getStatusesFromSearch(this, string4);
                }
                throw parsing;
            }
            catch (TwitterException.E403 e403) {
                if (e403.getMessage() != null && e403.getMessage().startsWith("code 195:")) {
                    throw new TwitterException.E406("Search too long/complex: " + e403.getMessage());
                }
                throw e403;
            }
            n2 = list.size();
            bigInteger = InternalUtils.getMinId(bigInteger, list);
            list = this.dateFilter(list);
            arrayList.addAll(list);
        } while (!(iCallback != null && iCallback.process(list) || n == 100 && n2 < 70 || n2 < n) && arrayList.size() < this.maxResults);
        return arrayList;
    }

    @Deprecated
    public List<User> searchUsers(String string) {
        return this.users().searchUsers(string);
    }

    public Message sendMessage(String string, String string2) throws TwitterException {
        if (NID.matcher(string).matches()) {
            InternalUtils.log("DM", "Numerical recipient ID passed as String");
            return this.sendMessage(new BigInteger(string), string2);
        }
        User user = this.users().getUser(string);
        return this.sendMessage(user.id, string2);
    }

    public Message sendMessage(Number number, String string) {
        assert (number != null && string != null) : number + " " + string;
        assert (!string.startsWith("d " + number)) : number + " " + string;
        if (string.length() > MAX_DM_LENGTH) {
            throw new IllegalArgumentException("Message is too long.");
        }
        JSONObject jSONObject = this.makeMessageObject(number, string);
        String string2 = null;
        try {
            string2 = this.postJSON(this.TWITTER_URL + "/direct_messages/events/new.json", jSONObject, true);
            JSONObject jSONObject2 = new JSONObject(string2);
            JSONObject jSONObject3 = jSONObject2.getJSONObject("event");
            Message message = new Message(jSONObject3);
            return message;
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string2, jSONException);
        }
        catch (TwitterException.E403 e403) {
            if (e403.getMessage() != null && e403.getMessage().startsWith("code 151:")) {
                throw new TwitterException.Repetition("DM " + number + " " + string + " Error:" + e403);
            }
            throw e403;
        }
        catch (TwitterException.E404 e404) {
            throw new TwitterException.MissingUser(e404.getMessage() + " with recipient=" + number + ", text=" + string);
        }
    }

    private JSONObject makeMessageObject(Number number, String string) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("recipient_id", number);
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("text", string);
        JSONObject jSONObject3 = new JSONObject();
        jSONObject3.put("target", jSONObject);
        jSONObject3.put("message_data", jSONObject2);
        JSONObject jSONObject4 = new JSONObject();
        jSONObject4.put("message_create", jSONObject3);
        jSONObject4.put("type", "message_create");
        JSONObject jSONObject5 = new JSONObject();
        jSONObject5.put("event", jSONObject4);
        return jSONObject5;
    }

    public void setAPIRootUrl(String string) {
        assert (string.startsWith("http://") || string.startsWith("https://")) : string;
        assert (!string.endsWith("/")) : "Please remove the trailing / from " + string;
        this.TWITTER_URL = string;
    }

    public void setCount(Integer n) {
        this.count = n;
    }

    public Status setFavorite(Status status, boolean bl) {
        try {
            String string = bl ? this.TWITTER_URL + "/favorites/create.json" : this.TWITTER_URL + "/favorites/destroy.json";
            String string2 = this.http.post(string, InternalUtils.asMap("id", status.id), true);
            return new Status(new JSONObject(string2), null);
        }
        catch (TwitterException.E403 e403) {
            if (e403.getMessage() != null && e403.getMessage().contains("already favorited")) {
                return null;
            }
            throw e403;
        }
    }

    public void setIncludeRTs(boolean bl) {
        this.includeRTs = bl;
    }

    public void setIncludeTweetEntities(boolean bl) {
        this.tweetEntities = bl;
    }

    public void setLanguage(String string) {
        this.lang = string;
    }

    public void setMaxResults(int n) {
        assert (n != 0);
        this.maxResults = n;
    }

    public void setMyLocation(double[] dArray) {
        this.myLatLong = dArray;
        if (this.myLatLong == null) {
            return;
        }
        if (Math.abs(this.myLatLong[0]) > 90.0) {
            throw new IllegalArgumentException(this.myLatLong[0] + " is not within +/- 90");
        }
        if (Math.abs(this.myLatLong[1]) > 180.0) {
            throw new IllegalArgumentException(this.myLatLong[1] + " is not within +/- 180");
        }
    }

    public void setSearchLocation(double d, double d2, String string) {
        assert (string.endsWith("mi") || string.endsWith("km")) : string;
        this.geocode = (float)d + "," + (float)d2 + "," + string;
    }

    public String getSearchLocation() {
        return this.geocode;
    }

    public void setSearchResultType(String string) {
        this.resultType = string;
    }

    @Deprecated
    public void setSinceDate(Date date) {
        this.sinceDate = date;
    }

    public void setSinceId(Number number) {
        this.sinceId = InternalUtils.toBigInteger(number);
    }

    public void setSource(String string) {
        this.sourceApp = string;
    }

    public Status setStatus(String string) throws TwitterException {
        return this.updateStatus(string);
    }

    @Deprecated
    public void setUntilDate(Date date) {
        this.untilDate = date;
    }

    public void setUntilId(Number number) {
        this.untilId = InternalUtils.toBigInteger(number);
    }

    public BigInteger getUntilId() {
        return this.untilId;
    }

    public BigInteger getSinceId() {
        return this.sinceId;
    }

    public void setExtendedMode(Boolean bl) {
        this.extendedMode = bl;
    }

    public void setAutoPopulateReplyMetadata(Boolean bl) {
        this.autoPopulateReplyMetadata = bl;
    }

    public void setupTwitlonger(String string, String string2) {
        this.twitlongerAppName = string;
        this.twitlongerApiKey = string2;
    }

    @Deprecated
    public User show(Number number) {
        return this.users().show(number);
    }

    @Deprecated
    public User show(String string) throws TwitterException, TwitterException.SuspendedUser {
        return this.users().show(string);
    }

    public List<String> splitMessage(String string) {
        String[] stringArray;
        if (string.length() <= 280) {
            return Collections.singletonList(string);
        }
        ArrayList<String> arrayList = new ArrayList<String>(4);
        StringBuilder stringBuilder = new StringBuilder(280);
        for (String string2 : stringArray = string.split("\\s+")) {
            if (stringBuilder.length() + string2.length() + 1 > 280) {
                stringBuilder.append("...");
                arrayList.add(stringBuilder.toString());
                stringBuilder = new StringBuilder(280);
                stringBuilder.append(string2);
                continue;
            }
            if (stringBuilder.length() != 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string2);
        }
        if (stringBuilder.length() != 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    private Map<String, String> standardishParameters() {
        return this.addStandardishParameters(new HashMap<String, String>());
    }

    @Deprecated
    public User stopFollowing(String string) {
        return this.users().stopFollowing(string);
    }

    @Deprecated
    public User stopFollowing(User user) {
        return this.stopFollowing(user.screenName);
    }

    public boolean updateConfiguration() {
        String string = this.http.getPage(this.TWITTER_URL + "/help/configuration.json", null, true);
        boolean bl = false;
        try {
            JSONObject jSONObject = new JSONObject(string);
            int n = jSONObject.getInt("short_url_length");
            if (n != LINK_LENGTH) {
                bl = true;
            }
            LINK_LENGTH = n;
            n = jSONObject.getInt("characters_reserved_per_media");
            if (n != MEDIA_LENGTH) {
                bl = true;
            }
            MEDIA_LENGTH = n;
            long l = jSONObject.getLong("photo_size_limit");
            if (l != PHOTO_SIZE_LIMIT) {
                bl = true;
            }
            PHOTO_SIZE_LIMIT = l;
            int n2 = jSONObject.getInt("dm_text_character_limit");
            if (n2 != MAX_DM_LENGTH) {
                bl = true;
            }
            MAX_DM_LENGTH = n2;
            return bl;
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string, jSONException);
        }
    }

    public Status updateLongStatus(String string, Number number) {
        TwitLonger twitLonger = new TwitLonger(this, this.twitlongerApiKey, this.twitlongerAppName);
        return twitLonger.updateLongStatus(string, number);
    }

    public Status updateStatus(String string) {
        return this.updateStatus(string, null);
    }

    public static int countCharacters(String string) {
        Object object;
        int n = string.length();
        Matcher matcher = Regex.VALID_URL.matcher(string);
        while (matcher.find()) {
            object = matcher.group();
            n += LINK_LENGTH - ((String)object).length();
        }
        object = InternalUtils.DM.matcher(string);
        if (((Matcher)object).find()) {
            n -= ((Matcher)object).end();
        }
        return n;
    }

    public Status updateStatus(String string, Number number) throws TwitterException {
        return this.updateStatus(string, number, null);
    }

    public Status updateStatus(String string, Number number, List<Number> list) {
        Map<String, String> map = this.updateStatus2_vars(string, number, list);
        String string2 = this.http.post(this.TWITTER_URL + "/statuses/update.json", map, true);
        try {
            Status status = new Status(new JSONObject(string2), null);
            return status;
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string2, jSONException);
        }
    }

    private Map<String, String> updateStatus2_vars(String string, Number number, List<Number> list) {
        int n;
        if (string.length() > 280 && this.TWITTER_URL.contains("twitter") && CHECK_TWEET_LENGTH && (n = Twitter.countCharacters(string)) > 280) {
            if (string.startsWith("RT")) {
                throw new IllegalArgumentException("Status text must be 280 characters or less -- use Twitter.retweet() to do new-style retweets which can be a bit longer: " + string.length() + " " + string);
            }
            throw new IllegalArgumentException("Status text must be 280 characters or less: " + string.length() + " " + string);
        }
        Map map = InternalUtils.asMap("status", string);
        if (this.tweetEntities) {
            map.put("include_entities", "1");
        }
        if (this.myLatLong != null) {
            map.put("lat", Double.toString(this.myLatLong[0]));
            map.put("long", Double.toString(this.myLatLong[1]));
        }
        if (this.placeId != null) {
            map.put("place_id", Long.toString(this.placeId));
        }
        if (this.sourceApp != null) {
            map.put("source", this.sourceApp);
        }
        if (number != null) {
            map.put("in_reply_to_status_id", number.toString());
            this.updateStatus3_vars2_autopop(map, list);
        }
        if (this.extendedMode) {
            map.put("tweet_mode", "extended");
        }
        return map;
    }

    void updateStatus3_vars2_autopop(Map<String, String> map, List<Number> list) {
        if (!this.autoPopulateReplyMetadata) {
            return;
        }
        map.put("auto_populate_reply_metadata", "true");
        if (list != null && !list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Number number : list) {
                Number number2;
                if (number instanceof String) {
                    number = new BigInteger((String)((Object)number));
                }
                if ((number2 = number).longValue() < 1L) {
                    InternalUtils.log("jtwitter.error", "(skip) Invalid exclude_reply_user_ids ID: " + number);
                    continue;
                }
                stringBuilder.append(number2);
                stringBuilder.append(",");
            }
            InternalUtils.pop(stringBuilder, 1);
            map.put("exclude_reply_user_ids", stringBuilder.toString());
        }
    }

    public Status updateStatusWithVideo(String string, File file) {
        String string2 = this.uploadVideo(file);
        Status status = this.updateStatusWithUploadedMedia(string, null, Arrays.asList(string2));
        return status;
    }

    public Status updateStatusWithMedia(String string, BigInteger bigInteger, List<Number> list, File file) {
        if (file == null || !file.isFile()) {
            throw new IllegalArgumentException("Invalid file: " + file);
        }
        Map<String, String> map = this.updateStatus2_vars(string, bigInteger, list);
        map.put("media[]", (String)((Object)file));
        String string2 = null;
        try {
            String string3 = this.TWITTER_URL + "/statuses/update_with_media.json";
            string2 = ((OAuthSignpostClient)this.http).postMultipartForm(string3, map);
            Status status = new Status(new JSONObject(string2), null);
            return status;
        }
        catch (TwitterException.E403 e403) {
            Status status = this.getStatus();
            if (status != null && status.getText().equals(string)) {
                throw new TwitterException.Repetition(status.getText());
            }
            throw e403;
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string2, jSONException);
        }
    }

    public Status updateStatusWithMedia(String string, BigInteger bigInteger, File file) {
        return this.updateStatusWithMedia(string, bigInteger, null, file);
    }

    public Status updateStatusWithMedia(String string, BigInteger bigInteger, List<Number> list, List<File> list2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file : list2) {
            if (file == null || !file.isFile()) {
                throw new IllegalArgumentException("Invalid file: " + file);
            }
            HashMap<String, File> hashMap = new HashMap<String, File>();
            hashMap.put("media", file);
            String string2 = "https://upload.twitter.com/1.1/media/upload.json";
            String string3 = ((OAuthSignpostClient)this.http).postMultipartForm(string2, hashMap);
            JSONObject jSONObject = new JSONObject(string3);
            String string4 = jSONObject.optString("media_id_string");
            if (string4 == null) continue;
            arrayList.add(string4);
        }
        return this.updateStatusWithUploadedMedia(string, bigInteger, list, arrayList);
    }

    public Status updateStatusWithMedia(String string, BigInteger bigInteger, List<File> list) {
        return this.updateStatusWithMedia(string, bigInteger, null, list);
    }

    public String uploadVideo(File file) {
        String string = file.getName().substring(file.getName().lastIndexOf(46));
        Object object = (String)InternalUtils.asMap(".mov", "video/quicktime", ".avi", "video/x-msvideo", ".wmv", "video/x-ms-wmv", ".m4v", "video/mp4", ".mp4", "video/mp4").get(string);
        if (object == null) {
            object = "video/" + string;
        }
        boolean bl = file.length() > 15000000L;
        return this.uploadVideo(file, (String)object, bl);
    }

    public String uploadVideo(File file, String string, boolean bl) {
        String string2;
        Map map;
        if (!file.isFile()) {
            throw new RuntimeException(new FileNotFoundException(file.getAbsolutePath()));
        }
        long l = file.length();
        if (l > VIDEO_SIZE_LIMIT) {
            throw new TwitterException.UploadTooBig("File " + file + " is " + l / 0x100000L + "mb which exceeds the maximum video upload of " + VIDEO_SIZE_LIMIT / 0x100000L);
        }
        Map map2 = InternalUtils.asMap("command", "INIT", "media_type", string, "total_bytes", l, "media_category", "tweet_video");
        String string3 = this.http.post("https://upload.twitter.com/1.1/media/upload.json", map2, true);
        JSONObject jSONObject = new JSONObject(string3);
        String string4 = jSONObject.optString("media_id_string");
        if (l < 5120000L) {
            map = InternalUtils.asMap("command", "APPEND", "media_id", string4, "segment_index", 0);
            map.put("media", file);
            string2 = ((OAuthSignpostClient)this.http).postMultipartForm("https://upload.twitter.com/1.1/media/upload.json", map);
        } else {
            this.uploadVideo2_chunks(file, bl, string4);
        }
        map = InternalUtils.asMap("command", "FINALIZE", "media_id", string4);
        string2 = this.http.post("https://upload.twitter.com/1.1/media/upload.json", map, true);
        JSONObject jSONObject2 = new JSONObject(string2);
        String string5 = jSONObject2.optString("media_id_string");
        try {
            while (true) {
                Thread.sleep(50L);
                String string6 = this.http.getPage("https://upload.twitter.com/1.1/media/upload.json", InternalUtils.asMap("command", "STATUS", "media_id", string4), true);
                JSONObject jSONObject3 = new JSONObject(string6);
                JSONObject jSONObject4 = jSONObject3.getJSONObject("processing_info");
                String string7 = jSONObject4.getString("state");
                int n = jSONObject4.optInt("check_after_secs");
                System.out.println(jSONObject4);
                if ("in_progress".equals(string7)) {
                    Thread.sleep(Math.max(2 * n, 1) * 500);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string5;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void uploadVideo2_chunks(File file, boolean bl, String string) {
        FileInputStream fileInputStream = null;
        ExecutorService executorService = bl ? Executors.newFixedThreadPool(10) : null;
        final AtomicReference atomicReference = new AtomicReference();
        try {
            fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[5120000];
            for (int i = 0; i < 100000 && atomicReference.get() == null; ++i) {
                int n;
                int n2;
                for (n = 0; ((InputStream)fileInputStream).available() > 0 && n < 5120000; n += n2) {
                    n2 = ((InputStream)fileInputStream).read(byArray, n, 5120000);
                }
                if (n == 0) break;
                StringBuilder stringBuilder = Base64Encoder.encode(byArray, 0, n, null);
                final Map map = InternalUtils.asMap("command", "APPEND", "media_id", string, "segment_index", i);
                System.out.println("segment " + i);
                map.put("media_data", stringBuilder.toString());
                if (bl) {
                    executorService.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String string = ((OAuthSignpostClient)Twitter.this.http).postMultipartForm("https://upload.twitter.com/1.1/media/upload.json", map);
                            }
                            catch (Exception exception) {
                                atomicReference.set(exception);
                            }
                        }
                    });
                    continue;
                }
                String string2 = ((OAuthSignpostClient)this.http).postMultipartForm("https://upload.twitter.com/1.1/media/upload.json", map);
            }
            if (executorService != null) {
                executorService.shutdown();
                executorService.awaitTermination(2L, TimeUnit.MINUTES);
            }
            if (atomicReference.get() != null) {
                throw (Exception)atomicReference.get();
            }
        }
        catch (TwitterException twitterException) {
            try {
                throw twitterException;
                catch (Exception exception) {
                    throw new TwitterException(exception);
                }
            }
            catch (Throwable throwable) {
                InternalUtils.close(fileInputStream);
                if (executorService == null) throw throwable;
                executorService.shutdownNow();
                throw throwable;
            }
        }
        InternalUtils.close(fileInputStream);
        if (executorService == null) return;
        executorService.shutdownNow();
    }

    public Status updateStatusWithUploadedMedia(String string, BigInteger bigInteger, List<Number> list, List<String> list2) {
        String string2;
        Map<String, String> map = this.updateStatus2_vars(string, bigInteger, list);
        if (list2 != null && !list2.isEmpty()) {
            string2 = InternalUtils.join(list2.toArray(new String[0]));
            map.put("media_ids", string2);
        }
        string2 = null;
        try {
            String string3 = this.TWITTER_URL + "/statuses/update.json";
            string2 = this.http.post(string3, map, true);
            Status status = new Status(new JSONObject(string2), null);
            return status;
        }
        catch (TwitterException.E403 e403) {
            Status status = this.getStatus();
            if (status != null && status.getText().equals(string)) {
                throw new TwitterException.Repetition(status.getText());
            }
            throw e403;
        }
        catch (JSONException jSONException) {
            throw new TwitterException.Parsing(string2, jSONException);
        }
    }

    public Status updateStatusWithUploadedMedia(String string, BigInteger bigInteger, List<String> list) {
        return this.updateStatusWithUploadedMedia(string, bigInteger, null, list);
    }

    public Twitter_Users users() {
        return new Twitter_Users(this);
    }

    public void setSearchLocation(IPlace iPlace) {
        if (iPlace == null) {
            this.geocode = null;
            return;
        }
        Location location = iPlace.getCentroid();
        if (location == null) {
            throw new IllegalArgumentException("Geo-search needs lat/long coordinates - none in " + iPlace);
        }
        BoundingBox boundingBox = iPlace.getBoundingBox();
        if (boundingBox == null) {
            this.setSearchLocation(location.latitude, location.longitude, "10km");
            return;
        }
        Location location2 = boundingBox.getNorthEast();
        Location location3 = boundingBox.getSouthWest();
        assert (location2 != null && location3 != null) : boundingBox;
        float f = (int)location2.distance(location3).getValue();
        float f2 = Math.max(f / 2000.0f, 5000.0f);
        f2 = Math.min(f2, 2499.0f);
        String string = f2 + "km";
        this.setSearchLocation(location.latitude, location.longitude, string);
    }

    public boolean isRateLimited(String string, boolean bl) {
        Map<String, RateLimit> map = this.getHttpClient().getRateLimits();
        if (map == null) {
            return bl;
        }
        RateLimit rateLimit = map.get(string);
        if (rateLimit == null) {
            return bl;
        }
        if (rateLimit.isOutOfDate()) {
            return bl;
        }
        return rateLimit.getRemaining() <= 0;
    }

    static {
        CHECK_TWEET_LENGTH = true;
        LINK_LENGTH = 23;
        MEDIA_LENGTH = 23;
        PHOTO_SIZE_LIMIT = 0x300000L;
        VIDEO_SIZE_LIMIT = 0x9600000L;
        MAX_DM_LENGTH = 10000;
        WORRIED_ABOUT_TWITTER = false;
        NID = Pattern.compile("\\d{6,20}");
    }

    public static interface IHttpClient {
        public boolean canAuthenticate();

        public HttpURLConnection connect(String var1, Map<String, String> var2, boolean var3) throws IOException;

        public IHttpClient copy();

        public String getHeader(String var1);

        public String getPage(String var1, Map<String, String> var2, boolean var3) throws TwitterException;

        public RateLimit getRateLimit(KRequestType var1);

        public Map<String, RateLimit> getRateLimits();

        public String post(String var1, Map<String, String> var2, boolean var3) throws TwitterException;

        public String postJSON(String var1, JSONObject var2, boolean var3) throws TwitterException;

        public String delete(String var1, boolean var2) throws TwitterException;

        public HttpURLConnection post2_connect(String var1, Map<String, String> var2) throws Exception;

        public HttpURLConnection post2_connect(String var1, JSONObject var2) throws Exception;

        public HttpURLConnection post2_connect(String var1, String var2) throws Exception;

        public void setTimeout(int var1);

        public boolean isRetryOnError();

        public void setRetryOnError(boolean var1);
    }

    public static interface ITweet
    extends Serializable {
        public Date getCreatedAt();

        public BigInteger getId();

        public String getLocation();

        public List<String> getMentions();

        public Place getPlace();

        public String getText();

        public List<TweetEntity> getTweetEntities(KEntityType var1);

        public User getUser();

        public String getDisplayText();
    }

    public static enum KRequestType {
        NORMAL("/statuses/user_timeline"),
        SEARCH("/search/tweets"),
        SEARCH_USERS("/users/search"),
        SHOW_USER("/users/show"),
        UPLOAD_MEDIA("Media"),
        STREAM_KEYWORD(""),
        STREAM_USER("");

        final String rateLimit;

        private KRequestType(String string2) {
            this.rateLimit = string2;
        }
    }

    public static enum KEntityType {
        hashtags,
        urls,
        user_mentions,
        media,
        symbols,
        extended_entities;

    }

    public static final class TweetEntity
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final String display;
        public final int end;
        public final int start;
        private final ITweet tweet;
        public final KEntityType type;
        final String mediaUrl;

        static ArrayList<TweetEntity> parse(ITweet iTweet, String string, KEntityType kEntityType, JSONObject jSONObject) throws JSONException {
            assert (kEntityType != null && iTweet != null && string != null && jSONObject != null) : iTweet + "\t" + string + "\t" + kEntityType + "\t" + jSONObject;
            try {
                JSONArray jSONArray = jSONObject.optJSONArray(kEntityType.toString());
                if (jSONArray == null || jSONArray.length() == 0) {
                    return null;
                }
                ArrayList<TweetEntity> arrayList = new ArrayList<TweetEntity>(jSONArray.length());
                for (int i = 0; i < jSONArray.length(); ++i) {
                    JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                    TweetEntity tweetEntity = new TweetEntity(iTweet, string, kEntityType, jSONObject2, arrayList);
                    arrayList.add(tweetEntity);
                }
                return arrayList;
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        TweetEntity(ITweet iTweet, String string, KEntityType kEntityType, JSONObject jSONObject, ArrayList<TweetEntity> arrayList) throws JSONException {
            Object object;
            this.tweet = iTweet;
            this.type = kEntityType;
            switch (kEntityType) {
                case urls: {
                    object = jSONObject.opt("expanded_url");
                    this.display = JSONObject.NULL.equals(object) ? null : (String)object;
                    break;
                }
                case user_mentions: {
                    this.display = jSONObject.getString("name");
                    break;
                }
                case media: {
                    this.display = jSONObject.getString("display_url");
                    break;
                }
                default: {
                    this.display = null;
                }
            }
            this.mediaUrl = KEntityType.media.equals((Object)this.type) ? jSONObject.getString("media_url") : null;
            object = jSONObject.getJSONArray("indices");
            int n = ((JSONArray)object).getInt(0);
            int n2 = ((JSONArray)object).getInt(1);
            assert (n >= 0 && n2 >= n) : jSONObject;
            String string2 = iTweet.getText();
            if (string.regionMatches(n, string2, n, n2 - n)) {
                this.start = n;
                this.end = n2;
                return;
            }
            if ((n = Math.min(n, n2 = Math.min(n2, string.length()))) == n2) {
                switch (kEntityType) {
                    case hashtags: {
                        break;
                    }
                    case urls: {
                        Matcher matcher = Regex.VALID_URL.matcher(string2);
                        if (!matcher.find()) break;
                        this.start = matcher.start();
                        this.end = matcher.end();
                        return;
                    }
                }
                this.end = Math.min(n2, string2.length());
                this.start = Math.min(n, this.end);
                return;
            }
            String string3 = string.substring(n, n2);
            int n3 = 0;
            for (TweetEntity tweetEntity : arrayList) {
                if (!iTweet.getText().regionMatches(tweetEntity.start, string3, 0, string3.length())) continue;
                n3 = tweetEntity.end;
            }
            int n4 = string2.indexOf(string3, n3);
            if (n4 == -1 && (n4 = string2.indexOf(string3 = InternalUtils.unencode(string3))) == -1) {
                n4 = n;
            }
            this.start = n4;
            this.end = this.start + n2 - n;
        }

        TweetEntity(ITweet iTweet, KEntityType kEntityType, int n, int n2, String string) {
            this.tweet = iTweet;
            this.end = n2;
            this.start = n;
            this.type = kEntityType;
            this.display = string;
            this.mediaUrl = null;
        }

        public String displayVersion() {
            return this.display == null ? this.toString() : this.display;
        }

        public String mediaUrl() {
            return this.mediaUrl;
        }

        public String toString() {
            String string = this.tweet.getText();
            int n = Math.min(this.end, string.length());
            int n2 = Math.min(this.start, n);
            return string.substring(n2, n);
        }
    }

    public static interface ICallback {
        public boolean process(List<Status> var1);
    }
}

