/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter;

import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import winterwell.jtwitter.AStream;
import winterwell.jtwitter.InternalUtils;
import winterwell.jtwitter.Status;
import winterwell.jtwitter.Twitter;
import winterwell.jtwitter.TwitterException;

public class TwitterStream
extends AStream {
    public static int MAX_KEYWORDS = 400;
    public static final int MAX_KEYWORD_LENGTH = 60;
    public static final int MAX_USERS = 5000;
    static Map<String, AStream> user2stream = new ConcurrentHashMap<String, AStream>();
    private List<Long> follow;
    private List<double[]> locns;
    KMethod method = KMethod.sample;
    private List<String> track;

    public TwitterStream(Twitter twitter) {
        super(twitter);
    }

    @Override
    HttpURLConnection connect2() throws Exception {
        this.connect3_rateLimit();
        String string = "https://stream.twitter.com/1.1/statuses/" + this.method + ".json";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.follow != null && this.follow.size() != 0) {
            hashMap.put("follow", InternalUtils.join(this.follow, 0, Integer.MAX_VALUE));
        }
        if (this.track != null && this.track.size() != 0) {
            hashMap.put("track", InternalUtils.join(this.track, 0, Integer.MAX_VALUE));
        }
        if (hashMap.isEmpty() && this.method == KMethod.filter) {
            throw new IllegalStateException("No filters set for " + this);
        }
        hashMap.put("delimited", "length");
        HttpURLConnection httpURLConnection = this.client.post2_connect(string, hashMap);
        return httpURLConnection;
    }

    private void connect3_rateLimit() {
        if (this.jtwit.getScreenName() == null) {
            return;
        }
        AStream aStream = user2stream.get(this.jtwit.getScreenName());
        if (aStream != null && aStream.isConnected()) {
            throw new TwitterException.TooManyLogins("One account, one stream (running: " + aStream + "; trying to run" + this + ").\n\tBut streams OR their filter parameters, so one stream can do a lot.");
        }
        if (user2stream.size() > 500) {
            user2stream = new ConcurrentHashMap<String, AStream>();
        }
        user2stream.put(this.jtwit.getScreenName(), this);
    }

    @Override
    int fillInOutages2(Twitter twitter, AStream.Outage outage) {
        List<Status> list;
        int n = 0;
        if (this.method != KMethod.filter) {
            throw new UnsupportedOperationException();
        }
        if (this.track != null) {
            for (String object : this.track) {
                list = this.jtwit.search(object);
                for (Status status : list) {
                    if (this.tweets.contains(status)) continue;
                    this.tweets.add(status);
                    ++n;
                }
            }
        }
        if (this.follow != null) {
            for (Long l : this.follow) {
                list = this.jtwit.getUserTimeline(l);
                for (Status status : list) {
                    if (this.tweets.contains(status)) continue;
                    this.tweets.add(status);
                    ++n;
                }
            }
        }
        if (this.locns != null && !this.locns.isEmpty()) {
            throw new UnsupportedOperationException("TODO");
        }
        return n;
    }

    public List<String> getTrackKeywords() {
        return this.track;
    }

    public void setFollowUsers(List<Long> list) throws IllegalArgumentException {
        this.method = KMethod.filter;
        if (list != null && list.size() > 5000) {
            throw new IllegalArgumentException("Track upto 5000 users - not " + list.size());
        }
        this.follow = list;
    }

    public List<Long> getFollowUsers() {
        return this.follow;
    }

    @Deprecated
    public void setLocation(List<double[]> list) {
        this.method = KMethod.filter;
        this.locns = list;
        throw new RuntimeException("TODO! Not implemented yet (sorry)");
    }

    void setMethod(KMethod kMethod) {
        this.method = kMethod;
    }

    public void setTrackKeywords(List<String> list) {
        if (list.size() > MAX_KEYWORDS) {
            throw new IllegalArgumentException("Too many tracked terms: " + list.size() + " (" + MAX_KEYWORDS + " limit)");
        }
        for (String string : list) {
            if (string.length() <= 60) continue;
            throw new IllegalArgumentException("Track term too long: " + string + " (60 char limit)");
        }
        this.track = list;
        this.method = KMethod.filter;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TwitterStream");
        stringBuilder.append("[" + this.method);
        if (this.track != null) {
            stringBuilder.append(" track:" + InternalUtils.join(this.track, 0, 5));
        }
        if (this.follow != null && this.follow.size() > 0) {
            stringBuilder.append(" follow:" + InternalUtils.join(this.follow, 0, 5));
        }
        if (this.locns != null) {
            stringBuilder.append(" in:" + InternalUtils.join(this.locns, 0, 5));
        }
        stringBuilder.append(" by:" + this.jtwit.getScreenNameIfKnown());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public void setListenersOnly(boolean bl) {
        this.listenersOnly = bl;
    }

    public static enum KMethod {
        filter,
        firehose,
        links,
        retweet,
        sample;

    }
}

