/*
 * Decompiled with CFR 0.152.
 */
package winterwell.jtwitter.ecosystem;

import com.winterwell.json.JSONException;
import com.winterwell.json.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public class TwitterCounterStats {
    public final String screenName;
    public final Date dateUpdated;
    public final int followDays;
    public final double avgGrowth;
    public final long rank;
    public final ArrayList<DateValue> data;
    static final SimpleDateFormat format = new SimpleDateFormat("'date'yyyy-MM-dd");
    static final SimpleDateFormat duformat = new SimpleDateFormat("yyyy-MM-dd");
    public final String website;

    public String toString() {
        if (this.data.isEmpty()) {
            return "TwitterCounterStats[@" + this.screenName + " no data]";
        }
        Date date = this.data.get((int)0).date;
        Date date2 = this.data.get((int)(this.data.size() - 1)).date;
        return "TwitterCounterStats[@" + this.screenName + " " + this.data.size() + " pts from " + date + " to " + date2 + "]";
    }

    TwitterCounterStats(JSONObject jSONObject) throws JSONException, ParseException {
        this.screenName = jSONObject.getString("username");
        this.dateUpdated = duformat.parse(jSONObject.getString("date_updated"));
        this.followDays = jSONObject.getInt("follow_days");
        this.avgGrowth = jSONObject.getDouble("average_growth");
        this.website = jSONObject.optString("url");
        this.rank = jSONObject.getLong("rank");
        Map<String, ?> map = jSONObject.getJSONObject("followersperdate").getMap();
        this.data = new ArrayList(map.size());
        for (String string : map.keySet()) {
            Date date = format.parse(string);
            int n = (Integer)map.get(string);
            this.data.add(new DateValue(date, n));
        }
        Collections.sort(this.data);
    }

    public static final class DateValue
    implements Comparable<DateValue> {
        public final int value;
        public final Date date;

        DateValue(Date date, int n) {
            this.date = date;
            this.value = n;
        }

        public String toString() {
            return this.date + ": " + this.value;
        }

        @Override
        public int compareTo(DateValue dateValue) {
            return this.date.compareTo(dateValue.date);
        }
    }
}

