/*
 * Decompiled with CFR 0.152.
 */
package winterwell.markdown.preferences;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import winterwell.markdown.Activator;

public class MarkdownPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREF_FOLDING = "Pref_Folding";
    public static final String PREF_WORD_WRAP = "Pref_WordWrap";
    public static final String PREF_TASK_TAGS = "Pref_TaskTagsOn";
    public static final String PREF_TASK_TAGS_DEFINED = "Pref_TaskTags";
    public static final String PREF_SECTION_NUMBERS = "Pref_SectionNumbers";
    public static final String PREF_MARKDOWN_COMMAND = "Pref_Markdown_Command";
    private static final String MARKDOWNJ = "(use built-in MarkdownJ converter)";
    public static final String PREF_DEFUALT = "Pref_Default";
    public static final String PREF_COMMENT = "Pref_Comment";
    public static final String PREF_HEADER = "Pref_Header";
    private static final RGB DEF_DEFAULT = new RGB(0, 0, 0);
    private static final RGB DEF_COMMENT = new RGB(128, 0, 0);
    private static final RGB DEF_HEADER = new RGB(0, 0, 128);

    public MarkdownPreferencePage() {
        super(1);
        IPreferenceStore pStore = Activator.getDefault().getPreferenceStore();
        pStore.setDefault(PREF_WORD_WRAP, false);
        pStore.setDefault(PREF_FOLDING, true);
        pStore.setDefault(PREF_TASK_TAGS, true);
        pStore.setDefault(PREF_TASK_TAGS_DEFINED, "TODO,FIXME,??");
        pStore.setDefault(PREF_MARKDOWN_COMMAND, MARKDOWNJ);
        pStore.setDefault(PREF_SECTION_NUMBERS, true);
        PreferenceConverter.setDefault((IPreferenceStore)pStore, (String)PREF_DEFUALT, (RGB)DEF_DEFAULT);
        PreferenceConverter.setDefault((IPreferenceStore)pStore, (String)PREF_COMMENT, (RGB)DEF_COMMENT);
        PreferenceConverter.setDefault((IPreferenceStore)pStore, (String)PREF_HEADER, (RGB)DEF_HEADER);
        this.setPreferenceStore(pStore);
        this.setDescription("Settings for the Markdown text editor. See also the general text editor preferences.");
    }

    public void createFieldEditors() {
        BooleanFieldEditor fd = new BooleanFieldEditor(PREF_WORD_WRAP, "Soft word wrapping \r\nNote: may cause line numbers and related \r\nfunctionality to act a bit strangely", this.getFieldEditorParent());
        this.addField((FieldEditor)fd);
        fd = new BooleanFieldEditor(PREF_TASK_TAGS, "Manage tasks using task tags \r\nIf true, this will add and delete tags in sync with edits.", this.getFieldEditorParent());
        this.addField((FieldEditor)fd);
        StringFieldEditor tags = new StringFieldEditor(PREF_TASK_TAGS_DEFINED, "Task tags\nComma separated list of recognised task tags.", this.getFieldEditorParent());
        this.addField((FieldEditor)tags);
        fd = new BooleanFieldEditor(PREF_FOLDING, "Document folding, a.k.a. outline support", this.getFieldEditorParent());
        this.addField((FieldEditor)fd);
        StringFieldEditor cmd = new StringFieldEditor(PREF_MARKDOWN_COMMAND, "UNSTABLE: Command-line to run Markdown.\r\nThis should take in a file and output to std-out.\nLeave blank to use the built-in Java converter.", this.getFieldEditorParent());
        this.addField((FieldEditor)cmd);
        ColorFieldEditor def = new ColorFieldEditor(PREF_DEFUALT, "Default text", this.getFieldEditorParent());
        this.addField((FieldEditor)def);
        ColorFieldEditor com = new ColorFieldEditor(PREF_COMMENT, "Comment", this.getFieldEditorParent());
        this.addField((FieldEditor)com);
        ColorFieldEditor head = new ColorFieldEditor(PREF_HEADER, "Header", this.getFieldEditorParent());
        this.addField((FieldEditor)head);
    }

    public void init(IWorkbench workbench) {
    }

    public static boolean wordWrap() {
        IPreferenceStore pStore = Activator.getDefault().getPreferenceStore();
        if (!pStore.contains(PREF_WORD_WRAP)) {
            return false;
        }
        return pStore.getBoolean(PREF_WORD_WRAP);
    }
}

